/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdns.dns;

import cn.schoolwow.quickdao.dao.DAO;
import cn.schoolwow.quickdns.config.QuickDNSServerConfig;
import cn.schoolwow.quickdns.dns.DNSServerUtil;
import cn.schoolwow.quickdns.dns.domain.DNSPacket;
import cn.schoolwow.quickdns.dns.domain.DNSRequest;
import cn.schoolwow.quickdns.dns.domain.DNSResponse;
import cn.schoolwow.quickdns.dns.domain.header.constant.AA;
import cn.schoolwow.quickdns.dns.domain.header.constant.QR;
import cn.schoolwow.quickdns.dns.domain.header.constant.RCODE;
import cn.schoolwow.quickdns.dns.domain.question.Question;
import cn.schoolwow.quickdns.dns.domain.question.constants.QTYPE;
import cn.schoolwow.quickdns.dns.domain.resourceRecord.ResourceRecord;
import cn.schoolwow.quickdns.domain.DNSHandleRequest;
import cn.schoolwow.quickdns.domain.DNSHandleResponse;
import cn.schoolwow.quickdns.entity.DNSForwardServer;
import cn.schoolwow.quickdns.entity.DNSRecord;
import cn.schoolwow.quickdns.entity.QueryRecord;
import cn.schoolwow.quickdns.util.IPUtil;
import cn.schoolwow.quickhttp.QuickHttp;
import cn.schoolwow.quickhttp.request.Request;
import cn.schoolwow.quickhttp.response.Response;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DNSHandler {
    private Logger logger = LoggerFactory.getLogger(DNSHandler.class);
    public static List<DNSForwardServer> dnsForwardServerList = new CopyOnWriteArrayList<DNSForwardServer>();
    public static Map<String, List<String>> dnsBlockCache = new HashMap<String, List<String>>();
    public static Set<String> gfwDomainSet = new HashSet<String>();
    @Resource
    private DAO dao;

    public DNSHandleResponse handleDNS(DNSHandleRequest dnsHandleRequest) {
        DNSHandleResponse dnsHandleResponse = new DNSHandleResponse();
        dnsHandleResponse.dnsResponse.header = dnsHandleRequest.dnsRequest.header.clone();
        dnsHandleResponse.dnsResponse.header.qr = QR.RESPONSE;
        dnsHandleResponse.dnsResponse.questions = dnsHandleRequest.dnsRequest.questions;
        for (Question question : dnsHandleRequest.dnsRequest.questions) {
            if (this.getDNSResponseByBlockRecord(question, dnsHandleRequest, dnsHandleResponse) || this.getDNSResponseByLocalDNSRecord(question, dnsHandleRequest, dnsHandleResponse) || this.getDNSResponseByGFWList(question, dnsHandleRequest, dnsHandleResponse) || this.getDNSResponseByDNSForwardServer(question, dnsHandleRequest, dnsHandleResponse) || this.getDNSResponseByGatewayIp(question, dnsHandleRequest, dnsHandleResponse)) continue;
            this.logger.warn("[\u65e0\u6cd5\u5904\u7406\u95ee\u9898]\u95ee\u9898:{}", (Object)question);
            try {
                Response response = QuickHttp.connect("https://ntfy.schoolwow.cn/quickdns").method(Request.Method.POST).setHeader("Title", "\u65e0\u6cd5\u5904\u7406DNS\u95ee\u9898").requestBody(question.toString()).execute();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        if (!dnsHandleResponse.queryRecordList.isEmpty()) {
            try {
                byte[] dnsResponseBytes = DNSPacket.writeDNSResponse(dnsHandleResponse.dnsResponse);
                String rawHex = DNSServerUtil.byteArrayToHex(dnsResponseBytes);
                for (QueryRecord queryRecord : dnsHandleResponse.queryRecordList) {
                    queryRecord.setRawHex(rawHex);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            dnsHandleResponse.dnsResponse.header = dnsHandleRequest.dnsRequest.header;
            dnsHandleResponse.dnsResponse.questions = dnsHandleRequest.dnsRequest.questions;
        }
        return dnsHandleResponse;
    }

    private boolean getDNSResponseByBlockRecord(Question question, DNSHandleRequest dnsHandleRequest, DNSHandleResponse dnsHandleResponse) {
        Set<String> keySet = dnsBlockCache.keySet();
        for (String key : keySet) {
            if (!question.qName.endsWith(key)) continue;
            List<QueryRecord> queryRecordList = this.getQueryRecordList(question.qName, dnsHandleResponse.dnsResponse, dnsHandleRequest);
            for (QueryRecord queryRecord : queryRecordList) {
                queryRecord.setHandleType(0);
                queryRecord.setHandlerIp("127.0.0.1");
            }
            dnsHandleResponse.queryRecordList.addAll(queryRecordList);
            this.logger.info("[\u8fd4\u56deDNS\u67e5\u8be2\u7ed3\u679c]\u6765\u6e90:DNS\u5c4f\u853d\u8bb0\u5f55,\u95ee\u9898:{}", (Object)question);
            return true;
        }
        return false;
    }

    private boolean getDNSResponseByLocalDNSRecord(Question question, DNSHandleRequest dnsHandleRequest, DNSHandleResponse dnsHandleResponse) {
        DNSRecord dnsRecord;
        int ipSource = 0;
        byte[] ipAddress = IPUtil.ipToBytes(dnsHandleRequest.requestIp);
        ipSource = IPUtil.internalIp(ipAddress) ? 1 : 2;
        List<DNSRecord> dnsRecordList = this.dao.query(DNSRecord.class).addQuery("host", question.qName).addQuery("enable", 1).addQuery("type", question.qType.name()).addColumn("type", "ipSource", "value").execute().getList();
        Iterator<DNSRecord> dnsRecordIterator = dnsRecordList.iterator();
        while (dnsRecordIterator.hasNext()) {
            dnsRecord = dnsRecordIterator.next();
            if (dnsRecord.getIpSource() <= 0 || dnsRecord.getIpSource() == ipSource) continue;
            dnsRecordIterator.remove();
        }
        if (null == dnsRecordList || dnsRecordList.isEmpty()) {
            dnsRecordList = this.dao.query(DNSRecord.class).addLikeQuery("host", "*.%").addQuery("enable", 1).addQuery("type", question.qType.name()).execute().getList();
            while (dnsRecordIterator.hasNext()) {
                dnsRecord = dnsRecordIterator.next();
                if (question.qName.endsWith(dnsRecord.getHost().substring(2))) continue;
                dnsRecordIterator.remove();
            }
        }
        if (null == dnsRecordList || dnsRecordList.isEmpty()) {
            return false;
        }
        ArrayList<ResourceRecord> answers = new ArrayList<ResourceRecord>();
        for (DNSRecord dnsRecord2 : dnsRecordList) {
            ResourceRecord answer = dnsHandleResponse.dnsResponse.answer(question, dnsRecord2.getValue());
            answer.qType = QTYPE.getQTYPEByName(dnsRecord2.getType());
            answers.add(answer);
            List<DNSRecord> additionalDNSRecordList = this.dao.query(DNSRecord.class).addQuery("host", question.qName).addQuery("enable", 1).addQuery("type", "!=", question.qType.name()).addColumn("type", "ipSource", "value").execute().getList();
            for (DNSRecord additionalDNSRecord : additionalDNSRecordList) {
                ResourceRecord additional = dnsHandleResponse.dnsResponse.additional(question, additionalDNSRecord.getValue());
                additional.qType = QTYPE.getQTYPEByName(additionalDNSRecord.getType());
            }
        }
        List<QueryRecord> queryRecordList = this.getQueryRecordList(question.qName, dnsHandleResponse.dnsResponse, dnsHandleRequest);
        for (QueryRecord queryRecord : queryRecordList) {
            queryRecord.setHandleType(0);
            queryRecord.setHandlerIp("127.0.0.1");
        }
        dnsHandleResponse.queryRecordList.addAll(queryRecordList);
        dnsHandleResponse.dnsResponse.header.aa = AA.AUTHORITATIVE_ANSWER;
        this.logger.info("[\u8fd4\u56deDNS\u67e5\u8be2\u7ed3\u679c]\u6765\u6e90:\u672c\u5730\u8bb0\u5f55,\u95ee\u9898:{}, \u7b54\u6848:{}", (Object)question, (Object)answers);
        return true;
    }

    private boolean getDNSResponseByGFWList(Question question, DNSHandleRequest dnsHandleRequest, DNSHandleResponse dnsHandleResponse) {
        if (QuickDNSServerConfig.quickDNSConfigProperties.enableGFW == 0) {
            return false;
        }
        for (String gfwDomain : gfwDomainSet) {
            if (!question.qName.endsWith(gfwDomain)) continue;
            this.logger.debug("\u5339\u914dGFW!\u5f53\u524d\u57df\u540d:{},GFW\u57df\u540d:{}", (Object)question.qName, (Object)gfwDomain);
            DNSRequest dnsRequest = new DNSRequest(question);
            dnsRequest.header = dnsHandleRequest.dnsRequest.header;
            try {
                DNSResponse dnsResponse = DNSServerUtil.sendDNSRequest(QuickDNSServerConfig.quickDNSConfigProperties.gfwDNS, 53, dnsRequest);
                List<QueryRecord> queryRecordList = this.getQueryRecordList(question.qName, dnsResponse, dnsHandleRequest);
                for (QueryRecord queryRecord : queryRecordList) {
                    queryRecord.setHandleType(3);
                    queryRecord.setHandlerIp(QuickDNSServerConfig.quickDNSConfigProperties.gfwDNS);
                }
                dnsHandleResponse.queryRecordList.addAll(queryRecordList);
                dnsHandleResponse.dnsResponse.answers.addAll(dnsResponse.answers);
                dnsHandleResponse.dnsResponse.authorities.addAll(dnsResponse.authorities);
                dnsHandleResponse.dnsResponse.additionals.addAll(dnsResponse.additionals);
                this.logger.info("[\u8fd4\u56deDNS\u67e5\u8be2\u7ed3\u679c]\u6765\u6e90:GFW,\u95ee\u9898:{}, \u7b54\u6848:{}", (Object)question, (Object)dnsHandleResponse.dnsResponse.answers);
                return true;
            }
            catch (IOException e) {
                this.logger.error("[\u8f6c\u53d1\u8bf7\u6c42\u5230GFW\u670d\u52a1\u5668\u5931\u8d25]DNS:{},\u67e5\u8be2\u8bf7\u6c42:{}", QuickDNSServerConfig.quickDNSConfigProperties.gfwDNS, Arrays.toString(dnsHandleRequest.dnsRequest.questions), e);
            }
        }
        return false;
    }

    private boolean getDNSResponseByDNSForwardServer(Question question, DNSHandleRequest dnsHandleRequest, DNSHandleResponse dnsHandleResponse) {
        for (DNSForwardServer dnsForwardServer : dnsForwardServerList) {
            String hostString = dnsForwardServer.getHosts();
            if (null != hostString && !hostString.isEmpty()) {
                String[] hostList = hostString.split(",", -1);
                boolean matchHost = false;
                for (String host : hostList) {
                    if (!question.qName.endsWith(host)) continue;
                    matchHost = true;
                    break;
                }
                if (!matchHost) continue;
            }
            try {
                List<QueryRecord> queryRecordList;
                DNSRequest dnsRequest = new DNSRequest(question);
                dnsRequest.header = dnsHandleRequest.dnsRequest.header;
                DNSResponse dnsResponse = DNSServerUtil.sendDNSRequest(dnsForwardServer.getIpv4(), dnsForwardServer.getPort(), dnsRequest);
                if (null == dnsResponse) {
                    this.logger.warn("[\u8f6c\u53d1\u8bf7\u6c42\u5230\u9012\u5f52DNS\u670d\u52a1\u5668\u5931\u8d25]\u9012\u5f52\u670d\u52a1\u5668IP:{},\u7aef\u53e3:{},\u67e5\u8be2\u8bf7\u6c42:{}", dnsForwardServer.getIpv4(), dnsForwardServer.getPort(), dnsHandleRequest.dnsRequest);
                    continue;
                }
                if (!dnsResponse.header.rcode.equals((Object)RCODE.SUCCESS)) {
                    this.logger.warn("[\u8f6c\u53d1\u8bf7\u6c42\u5230\u9012\u5f52DNS\u670d\u52a1\u5668]\u8fd4\u56de\u9519\u8bef\u62a5\u6587.\u9519\u8bef\u539f\u56e0:{},\u9012\u5f52\u670d\u52a1\u5668IP:{},\u7aef\u53e3:{},\u67e5\u8be2\u8bf7\u6c42:{}", dnsResponse.header.rcode.name(), dnsForwardServer.getIpv4(), dnsForwardServer.getPort(), dnsHandleRequest.dnsRequest);
                    queryRecordList = this.getQueryRecordList(question.qName, dnsResponse, dnsHandleRequest);
                    for (QueryRecord queryRecord : queryRecordList) {
                        queryRecord.setHandleType(1);
                        queryRecord.setHandlerIp(dnsForwardServer.getIpv4());
                    }
                    dnsHandleResponse.queryRecordList.addAll(queryRecordList);
                    continue;
                }
                queryRecordList = this.getQueryRecordList(question.qName, dnsResponse, dnsHandleRequest);
                for (QueryRecord queryRecord : queryRecordList) {
                    queryRecord.setHandleType(1);
                    queryRecord.setHandlerIp(dnsForwardServer.getIpv4());
                }
                dnsHandleResponse.queryRecordList.addAll(queryRecordList);
                dnsHandleResponse.dnsResponse.answers.addAll(dnsResponse.answers);
                dnsHandleResponse.dnsResponse.authorities.addAll(dnsResponse.authorities);
                dnsHandleResponse.dnsResponse.additionals.addAll(dnsResponse.additionals);
                this.logger.info("[\u8fd4\u56deDNS\u67e5\u8be2\u7ed3\u679c]\u6765\u6e90:DNS\u8f6c\u53d1\u670d\u52a1\u5668,\u95ee\u9898:{}, \u7b54\u6848:{}", (Object)question, (Object)dnsHandleResponse.dnsResponse.answers);
                return true;
            }
            catch (IOException e) {
                this.logger.error("[\u8f6c\u53d1\u8bf7\u6c42\u5230\u9012\u5f52DNS\u670d\u52a1\u5668\u5931\u8d25]\u9012\u5f52\u670d\u52a1\u5668IP:{},\u7aef\u53e3:{},\u67e5\u8be2\u8bf7\u6c42:{}", dnsForwardServer.getIpv4(), dnsForwardServer.getPort(), Arrays.toString(dnsHandleRequest.dnsRequest.questions), e);
            }
        }
        return false;
    }

    private boolean getDNSResponseByGatewayIp(Question question, DNSHandleRequest dnsHandleRequest, DNSHandleResponse dnsHandleResponse) {
        try {
            DNSRequest dnsRequest = new DNSRequest(question);
            dnsRequest.header = dnsHandleRequest.dnsRequest.header.clone();
            DNSResponse dnsResponse = DNSServerUtil.sendDNSRequest(QuickDNSServerConfig.quickDNSConfigProperties.gatewayIp, 53, dnsRequest);
            List<QueryRecord> queryRecordList = this.getQueryRecordList(question.qName, dnsResponse, dnsHandleRequest);
            for (QueryRecord queryRecord : queryRecordList) {
                queryRecord.setHandleType(2);
                queryRecord.setHandlerIp(QuickDNSServerConfig.quickDNSConfigProperties.gatewayIp);
            }
            dnsHandleResponse.queryRecordList.addAll(queryRecordList);
            dnsHandleResponse.dnsResponse.answers.addAll(dnsResponse.answers);
            dnsHandleResponse.dnsResponse.authorities.addAll(dnsResponse.authorities);
            dnsHandleResponse.dnsResponse.additionals.addAll(dnsResponse.additionals);
            if (dnsHandleResponse.dnsResponse.answers.isEmpty()) {
                this.logger.info("[\u8fd4\u56deDNS\u67e5\u8be2\u7ed3\u679c]\u6765\u6e90:\u7f51\u5173,\u65e0\u76f4\u63a5\u7b54\u6848,\u95ee\u9898:{},\u8ba4\u8bc1\u8d44\u6e90:{},\u9644\u52a0\u8d44\u6e90:{}", question, dnsHandleResponse.dnsResponse.authorities, dnsHandleResponse.dnsResponse.additionals);
            } else {
                this.logger.info("[\u8fd4\u56deDNS\u67e5\u8be2\u7ed3\u679c]\u6765\u6e90:\u7f51\u5173,\u95ee\u9898:{},\u7b54\u6848:{}", (Object)Arrays.toString(dnsResponse.questions), (Object)dnsHandleResponse.dnsResponse.answers);
            }
            return true;
        }
        catch (SocketTimeoutException e) {
            this.logger.warn("[\u8d85\u65f6\u5f02\u5e38]\u95ee\u9898:{}", (Object)question);
        }
        catch (Exception e) {
            e.printStackTrace();
            StringWriter sw = new StringWriter();
            sw.append("\u95ee\u9898:" + question + "\n");
            e.printStackTrace(new PrintWriter(sw));
            try {
                Response queryRecordList = QuickHttp.connect("https://ntfy.schoolwow.cn/quickdns").method(Request.Method.POST).setHeader("Title", "\u8f6c\u53d1\u8bf7\u6c42\u5230\u7f51\u5173DNS\u670d\u52a1\u5668\u5931\u8d25").requestBody(sw.toString()).execute();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return false;
    }

    private List<QueryRecord> getQueryRecordList(String qName, DNSResponse dnsResponse, DNSHandleRequest dnsHandleRequest) {
        ArrayList<QueryRecord> queryRecordList = new ArrayList<QueryRecord>();
        StringBuilder answerBuilder = new StringBuilder();
        for (Question question : dnsResponse.questions) {
            if (!question.qName.equalsIgnoreCase(qName)) continue;
            QueryRecord queryRecord = new QueryRecord();
            queryRecord.setRequestIp(dnsHandleRequest.requestIp);
            queryRecord.setType(question.qType.name());
            queryRecord.setHost(question.qName);
            queryRecord.setRcode(dnsResponse.header.rcode.value);
            queryRecord.setRequestHeader(dnsHandleRequest.dnsRequest.header.toString());
            JSONArray array = this.getResourceRecordArray(question, dnsResponse.answers);
            queryRecord.setAnswerCount(array.size());
            queryRecord.setAnswer(array.toJSONString());
            array = this.getResourceRecordArray(question, dnsResponse.authorities);
            queryRecord.setAuthorityCount(array.size());
            queryRecord.setAuthority(array.toJSONString());
            array = this.getResourceRecordArray(question, dnsResponse.additionals);
            queryRecord.setAdditionalCount(array.size());
            queryRecord.setAdditional(array.toJSONString());
            queryRecordList.add(queryRecord);
        }
        return queryRecordList;
    }

    private JSONArray getResourceRecordArray(Question question, List<ResourceRecord> resourceRecords) {
        JSONArray array = new JSONArray();
        for (ResourceRecord resourceRecord : resourceRecords) {
            if (!resourceRecord.qName.equals(question.qName)) continue;
            JSONObject o = new JSONObject();
            o.put("qType", (Object)resourceRecord.qType.name());
            o.put("data", (Object)resourceRecord.RDATAFormat);
            array.add(o);
        }
        return array;
    }
}

