/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdns.dns;

import cn.schoolwow.quickdao.dao.DAO;
import cn.schoolwow.quickdns.config.QuickDNSServerConfig;
import cn.schoolwow.quickdns.dns.DNSHandler;
import cn.schoolwow.quickdns.dns.domain.DNSPacket;
import cn.schoolwow.quickdns.dns.domain.DNSRequest;
import cn.schoolwow.quickdns.domain.DNSHandleRequest;
import cn.schoolwow.quickdns.domain.DNSHandleResponse;
import cn.schoolwow.quickdns.entity.QueryRecord;
import cn.schoolwow.quickhttp.QuickHttp;
import cn.schoolwow.quickhttp.request.Request;
import cn.schoolwow.quickhttp.response.Response;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;
import java.util.Arrays;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DNSServer {
    private Logger logger = LoggerFactory.getLogger(DNSServer.class);
    private ExecutorService executorService = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
    @Resource
    private DNSHandler dnsHandler;
    @Resource
    private DAO dao;

    @PostConstruct
    public void startDNSSever() {
        this.executorService.execute(() -> {
            try {
                DatagramSocket datagramSocket = new DatagramSocket(QuickDNSServerConfig.quickDNSConfigProperties.dnsListenPort);
                this.logger.info("[UDP\u76d1\u542c\u670d\u52a1\u542f\u52a8]\u672c\u5730\u5730\u5740:{}", (Object)datagramSocket.getLocalSocketAddress());
                while (true) {
                    byte[] data = new byte[512];
                    DatagramPacket datagramPacket = new DatagramPacket(data, data.length);
                    datagramSocket.receive(datagramPacket);
                    byte[] trimData = new byte[datagramPacket.getLength()];
                    System.arraycopy(data, 0, trimData, 0, trimData.length);
                    datagramPacket.setData(trimData);
                    byte[] requestData = datagramPacket.getData();
                    this.executorService.execute(() -> {
                        try {
                            DNSRequest dnsRequest = DNSPacket.readDNSRequest(requestData);
                            DNSHandleRequest dnsHandleRequest = new DNSHandleRequest();
                            dnsHandleRequest.dnsRequest = dnsRequest;
                            InetSocketAddress inetSocketAddress = (InetSocketAddress)datagramPacket.getSocketAddress();
                            dnsHandleRequest.requestIp = inetSocketAddress.getHostString();
                            this.logger.info("[\u63a5\u6536\u5230DNS\u67e5\u8be2\u8bf7\u6c42]\u8bf7\u6c42\u65b9\u5f0f:UDP,\u95ee\u9898:{},\u5934\u90e8:{}", (Object)Arrays.toString(dnsHandleRequest.dnsRequest.questions), (Object)dnsHandleRequest.dnsRequest.header);
                            DNSHandleResponse dnsHandleResponse = this.dnsHandler.handleDNS(dnsHandleRequest);
                            for (QueryRecord queryRecord : dnsHandleResponse.queryRecordList) {
                                queryRecord.setRequestType(0);
                            }
                            this.dao.insertIgnore(dnsHandleResponse.queryRecordList);
                            byte[] dnsResponseData = DNSPacket.writeDNSResponse(dnsHandleResponse.dnsResponse);
                            datagramSocket.send(new DatagramPacket(dnsResponseData, dnsResponseData.length, datagramPacket.getAddress(), datagramPacket.getPort()));
                        }
                        catch (SocketTimeoutException e) {
                            this.logger.warn("[\u89e3\u6790\u8d85\u65f6]{}", e);
                        }
                        catch (Exception e) {
                            this.logger.error("[\u89e3\u6790\u8bf7\u6c42\u62a5\u6587\u5931\u8d25]", e);
                            StringWriter sw = new StringWriter();
                            e.printStackTrace(new PrintWriter(sw));
                            try {
                                Response inetSocketAddress = QuickHttp.connect("https://ntfy.schoolwow.cn/quickdns").method(Request.Method.POST).setHeader("Title", "\u89e3\u6790\u8bf7\u6c42\u62a5\u6587\u5931\u8d25").requestBody(sw.toString()).execute();
                            }
                            catch (IOException ex) {
                                ex.printStackTrace();
                            }
                        }
                    });
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        });
    }
}

