/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdns.dns;

import cn.schoolwow.quickdns.config.QuickDNSServerConfig;
import cn.schoolwow.quickdns.dns.domain.DNSPacket;
import cn.schoolwow.quickdns.dns.domain.DNSRequest;
import cn.schoolwow.quickdns.dns.domain.DNSResponse;
import cn.schoolwow.quickdns.dns.domain.header.constant.RA;
import cn.schoolwow.quickdns.dns.domain.header.constant.RD;
import cn.schoolwow.quickdns.dns.domain.question.Question;
import cn.schoolwow.quickdns.dns.domain.question.constants.QTYPE;
import cn.schoolwow.quickdns.dns.domain.resourceRecord.ResourceRecord;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DNSServerUtil {
    private static Logger logger = LoggerFactory.getLogger(DNSServerUtil.class);

    public static String byteArrayToHex(byte[] bytes) {
        if (null == bytes || bytes.length == 0) {
            return "null";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < bytes.length; ++i) {
            String hex = Integer.toHexString(bytes[i] & 0xFF);
            if (hex.length() < 2) {
                sb.append(0);
            }
            sb.append(hex);
        }
        return sb.toString().toUpperCase();
    }

    public static byte[] hexToByteArray(String hex) {
        if (null == hex || hex.isEmpty()) {
            return null;
        }
        byte[] result = new byte[hex.length() / 2];
        int i = 0;
        for (int j = 0; j < result.length; ++j) {
            result[j] = (byte)Integer.parseInt(hex.substring(i, i + 2), 16);
            i += 2;
        }
        return result;
    }

    public static String reversePTR(String host) {
        if (host.toLowerCase().endsWith("in-addr.arpa")) {
            return host;
        }
        if (host.contains(":")) {
            throw new IllegalArgumentException("\u6682\u4e0d\u652f\u6301IPv6\u7684PTR\u8bb0\u5f55\u67e5\u8be2!");
        }
        String[] tokens = host.split("\\.");
        StringBuilder hostBuilder = new StringBuilder();
        for (int i = tokens.length - 1; i >= 0; --i) {
            hostBuilder.append(tokens[i] + ".");
        }
        hostBuilder.append("in-addr.arpa");
        return hostBuilder.toString();
    }

    public static DNSResponse sendDNSRequest(String ip, int port, DNSRequest dnsRequest) throws IOException {
        for (Question question : dnsRequest.questions) {
            if (!QTYPE.PTR.equals((Object)question.qType)) continue;
            dnsRequest.header.ra = RA.CAN_RECURSIVE;
            question.qName = DNSServerUtil.reversePTR(question.qName);
        }
        DNSResponse dnsResponse = DNSServerUtil.doSendDNSRequest(ip, port, dnsRequest);
        if (dnsRequest.header.rd.equals((Object)RD.ITERATIVE)) {
            return dnsResponse;
        }
        String lastForwardIp = null;
        while (RD.RECURSIVE.equals((Object)dnsRequest.header.rd) && dnsResponse.answers.isEmpty()) {
            ArrayList<ResourceRecord> resourceRecordList = new ArrayList<ResourceRecord>();
            resourceRecordList.addAll(dnsResponse.authorities);
            resourceRecordList.addAll(dnsResponse.additionals);
            long count = resourceRecordList.stream().filter(resourceRecord -> resourceRecord.qType.equals((Object)QTYPE.NS) || resourceRecord.qType.equals((Object)QTYPE.SOA)).count();
            if (count == 0L) break;
            String forwardIp = null;
            for (ResourceRecord resourceRecord2 : resourceRecordList) {
                if (QTYPE.NS.equals((Object)resourceRecord2.qType)) {
                    forwardIp = DNSServerUtil.searchIpFromResourceRecord(resourceRecord2.RDATAFormat, resourceRecordList);
                    break;
                }
                if (!QTYPE.SOA.equals((Object)resourceRecord2.qType)) continue;
                JSONObject o = JSON.parseObject(resourceRecord2.RDATAFormat);
                forwardIp = DNSServerUtil.searchIpFromResourceRecord(o.getString("mname"), resourceRecordList);
                break;
            }
            if (null != lastForwardIp && lastForwardIp.equalsIgnoreCase(forwardIp)) {
                logger.warn("[\u4e24\u6b21\u9012\u5f52\u67e5\u8be2\u8f6c\u53d1\u5730\u5740\u76f8\u540c]\u9012\u5f52\u67e5\u8be2\u5931\u8d25!");
                break;
            }
            lastForwardIp = forwardIp;
            logger.info("[\u9012\u5f52\u67e5\u8be2]\u95ee\u9898:{},\u8f6c\u53d1\u5730\u5740:{}", (Object)Arrays.toString(dnsRequest.questions), (Object)forwardIp);
            dnsResponse = DNSServerUtil.doSendDNSRequest(forwardIp, 53, dnsRequest);
        }
        dnsResponse.header.ra = dnsResponse.answers.isEmpty() ? RA.CAN_NOT_RECURSIVE : RA.CAN_RECURSIVE;
        return dnsResponse;
    }

    private static DNSResponse doSendDNSRequest(String ip, int port, DNSRequest dnsRequest) throws IOException {
        for (int i = 1; i <= QuickDNSServerConfig.quickDNSConfigProperties.dnsQueryForwardRetryTimes; ++i) {
            try {
                byte[] dnsRequestBytes = DNSPacket.writeDNSRequest(dnsRequest);
                DatagramSocket datagramSocket = new DatagramSocket();
                datagramSocket.setReuseAddress(true);
                datagramSocket.setSoTimeout(QuickDNSServerConfig.quickDNSConfigProperties.dnsQueryTimeoutSeconds * 1000);
                DatagramPacket datagramPacket = new DatagramPacket(dnsRequestBytes, dnsRequestBytes.length);
                datagramSocket.connect(new InetSocketAddress(ip, port));
                datagramSocket.send(datagramPacket);
                byte[] data = new byte[512];
                datagramPacket = new DatagramPacket(data, data.length);
                datagramSocket.receive(datagramPacket);
                byte[] trimData = new byte[datagramPacket.getLength()];
                System.arraycopy(data, 0, trimData, 0, trimData.length);
                datagramPacket.setData(trimData);
                DNSResponse dnsResponse = DNSPacket.readDNSResponse(datagramPacket.getData());
                return dnsResponse;
            }
            catch (SocketTimeoutException e) {
                logger.debug("[DNS\u67e5\u8be2\u8d85\u65f6]\u91cd\u8bd5{}/{}\u6b21,DNS:{},\u95ee\u9898:{}", i, QuickDNSServerConfig.quickDNSConfigProperties.dnsQueryForwardRetryTimes, ip, Arrays.toString(dnsRequest.questions));
                continue;
            }
        }
        throw new SocketTimeoutException("DNS\u67e5\u8be2\u8d85\u65f6!DNS:" + ip + ",\u95ee\u9898:" + Arrays.toString(dnsRequest.questions));
    }

    private static String searchIpFromResourceRecord(String address, List<ResourceRecord> resourceRecordList) {
        for (ResourceRecord resourceRecord : resourceRecordList) {
            if (!resourceRecord.qType.equals((Object)QTYPE.A) || !resourceRecord.qName.equalsIgnoreCase(address)) continue;
            return resourceRecord.RDATAFormat;
        }
        return address;
    }
}

