/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdns.dns.domain;

import cn.schoolwow.quickdns.dns.domain.DNSRequest;
import cn.schoolwow.quickdns.dns.domain.DNSResponse;
import cn.schoolwow.quickdns.dns.domain.header.Header;
import cn.schoolwow.quickdns.dns.domain.question.Question;
import cn.schoolwow.quickdns.dns.domain.resourceRecord.ResourceRecord;
import cn.schoolwow.quickdns.dns.stream.DNSStreamImpl;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashMap;

public class DNSPacket {
    public static DNSRequest readDNSRequest(byte[] data) throws IOException {
        ByteArrayInputStream baos = new ByteArrayInputStream(data);
        DNSStreamImpl dnsStream = new DNSStreamImpl(baos);
        Header header = Header.getHeader(dnsStream);
        HashMap<Integer, String> offsetStringCache = new HashMap<Integer, String>();
        Question[] questions = Question.readQuestions(dnsStream, header, data, offsetStringCache);
        DNSRequest dnsRequest = new DNSRequest();
        dnsRequest.header = header;
        dnsRequest.questions = questions;
        dnsRequest.rawBytes = data;
        return dnsRequest;
    }

    public static DNSResponse readDNSResponse(byte[] data) throws IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        DNSStreamImpl dnsStream = new DNSStreamImpl(bais);
        Header header = Header.getHeader(dnsStream);
        HashMap<Integer, String> offsetStringCache = new HashMap<Integer, String>();
        Question[] questions = Question.readQuestions(dnsStream, header, data, offsetStringCache);
        DNSResponse dnsResponse = new DNSResponse();
        dnsResponse.header = header;
        dnsResponse.questions = questions;
        if (bais.available() > 0) {
            int i;
            for (i = 0; i < header.answerResourceRecordCount; ++i) {
                dnsResponse.answers.add(ResourceRecord.readResourceRecord(dnsStream, data, offsetStringCache));
            }
            for (i = 0; i < header.authorityResourceRecordCount; ++i) {
                dnsResponse.authorities.add(ResourceRecord.readResourceRecord(dnsStream, data, offsetStringCache));
            }
            for (i = 0; i < header.additionalResourceRecordCount; ++i) {
                dnsResponse.additionals.add(ResourceRecord.readResourceRecord(dnsStream, data, offsetStringCache));
            }
        }
        dnsResponse.rawBytes = data;
        return dnsResponse;
    }

    public static byte[] writeDNSRequest(DNSRequest dnsRequest) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DNSStreamImpl dnsStream = new DNSStreamImpl(baos);
        Header.writeHeader(dnsRequest.header, dnsStream);
        HashMap<String, Integer> offsetStringCache = new HashMap<String, Integer>();
        for (Question question : dnsRequest.questions) {
            Question.writeQuestion(dnsStream, question, offsetStringCache);
        }
        return baos.toByteArray();
    }

    public static byte[] writeDNSResponse(DNSResponse dnsResponse) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DNSStreamImpl dnsStream = new DNSStreamImpl(baos);
        if (null == dnsResponse.header) {
            dnsResponse.header = new Header();
        }
        dnsResponse.header.answerResourceRecordCount = dnsResponse.answers.size();
        dnsResponse.header.authorityResourceRecordCount = dnsResponse.authorities.size();
        dnsResponse.header.additionalResourceRecordCount = dnsResponse.additionals.size();
        Header.writeHeader(dnsResponse.header, dnsStream);
        HashMap<String, Integer> offsetStringCache = new HashMap<String, Integer>();
        for (Question question : dnsResponse.questions) {
            Question.writeQuestion(dnsStream, question, offsetStringCache);
        }
        for (ResourceRecord answer : dnsResponse.answers) {
            ResourceRecord.writeResourceRecord(dnsStream, answer, offsetStringCache);
        }
        for (ResourceRecord authority : dnsResponse.authorities) {
            ResourceRecord.writeResourceRecord(dnsStream, authority, offsetStringCache);
        }
        for (ResourceRecord additional : dnsResponse.additionals) {
            ResourceRecord.writeResourceRecord(dnsStream, additional, offsetStringCache);
        }
        return baos.toByteArray();
    }
}

