/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdns.dns.domain.header;

import cn.schoolwow.quickdns.dns.domain.header.constant.AA;
import cn.schoolwow.quickdns.dns.domain.header.constant.OPCODE;
import cn.schoolwow.quickdns.dns.domain.header.constant.QR;
import cn.schoolwow.quickdns.dns.domain.header.constant.RA;
import cn.schoolwow.quickdns.dns.domain.header.constant.RCODE;
import cn.schoolwow.quickdns.dns.domain.header.constant.RD;
import cn.schoolwow.quickdns.dns.domain.header.constant.TC;
import cn.schoolwow.quickdns.dns.stream.DNSStream;
import cn.schoolwow.quickdns.util.BitUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class Header
implements Serializable,
Cloneable {
    public int id;
    public QR qr = QR.QUERY;
    public OPCODE opcode = OPCODE.STANDARD_QUERY;
    public AA aa = AA.NOT_AUTHORITATIVE_ANSWER;
    public TC tc = TC.NOT_TRUNCATE;
    public RD rd = RD.ITERATIVE;
    public RA ra = RA.CAN_NOT_RECURSIVE;
    public RCODE rcode = RCODE.SUCCESS;
    public int questionCount;
    public int answerResourceRecordCount;
    public int authorityResourceRecordCount;
    public int additionalResourceRecordCount;

    public static Header getHeader(DNSStream dnsStream) throws IOException {
        Header header = new Header();
        header.id = dnsStream.readUnsignedShort();
        int[] bits = dnsStream.readBitByte();
        header.qr = QR.getQR(bits[0]);
        header.opcode = OPCODE.getOPCODE(BitUtil.getBitValue(bits, 1, 3));
        header.aa = AA.getAA(bits[4]);
        header.tc = TC.getTC(bits[5]);
        header.rd = RD.getRD(bits[6]);
        header.ra = RA.getRA(bits[7]);
        bits = dnsStream.readBitByte();
        header.rcode = RCODE.getRCODE(BitUtil.getBitValue(bits, 4, 7));
        header.questionCount = dnsStream.readShort();
        header.answerResourceRecordCount = dnsStream.readShort();
        header.authorityResourceRecordCount = dnsStream.readShort();
        header.additionalResourceRecordCount = dnsStream.readShort();
        return header;
    }

    public static void writeHeader(Header header, DNSStream dnsStream) throws IOException {
        dnsStream.writeShort(header.id);
        int[] bits = new int[16];
        bits[0] = header.qr.value;
        BitUtil.setBitValue(bits, 1, 3, header.opcode.value);
        bits[4] = header.aa.value;
        bits[5] = header.tc.value;
        bits[6] = header.rd.value;
        bits[7] = header.ra.value;
        BitUtil.setBitValue(bits, 12, 15, header.rcode.value);
        dnsStream.writeShort(BitUtil.getBitValue(bits, 0, 15));
        dnsStream.writeShort(header.questionCount);
        dnsStream.writeShort(header.answerResourceRecordCount);
        dnsStream.writeShort(header.authorityResourceRecordCount);
        dnsStream.writeShort(header.additionalResourceRecordCount);
    }

    public String toString() {
        return "{\u6807\u8bc6:" + this.id + ",\u67e5\u8be2\u7c7b\u578b:" + this.qr.name() + ",\u64cd\u4f5c\u7c7b\u578b:" + this.opcode.name() + ",\u6743\u5a01\u56de\u7b54:" + this.aa.name() + ",\u622a\u65ad:" + this.tc.name() + ",\u5ba2\u6237\u7aef\u9012\u5f52\u67e5\u8be2:" + this.rd.name() + ",\u670d\u52a1\u7aef\u9012\u5f52\u67e5\u8be2:" + this.ra.name() + ",\u54cd\u5e94\u7c7b\u578b:" + this.rcode.name() + ",\u95ee\u9898\u4e2a\u6570:" + this.questionCount + ",\u7b54\u6848\u4e2a\u6570:" + this.answerResourceRecordCount + ",\u8ba4\u8bc1\u8d44\u6e90\u4e2a\u6570:" + this.authorityResourceRecordCount + ",\u9644\u52a0\u8d44\u6e90\u4e2a\u6570:" + this.additionalResourceRecordCount + "}";
    }

    public Header clone() {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(this);
            oos.close();
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            ObjectInputStream ois = new ObjectInputStream(bais);
            Header header = (Header)ois.readObject();
            bais.close();
            return header;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

