/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdns.dns.domain.question.constants;

public enum QTYPE {
    A(1),
    NS(2),
    CNAME(5),
    SOA(6),
    WKS(11),
    PTR(12),
    MX(15),
    TXT(16),
    AAAA(28),
    SRV(33),
    IXFR(251),
    AXFR(252),
    ALL(255),
    URI(256),
    Unknown(-1);

    public int value;

    private QTYPE(int value) {
        this.value = value;
    }

    public static QTYPE getQTYPE(short value) {
        switch (value) {
            case 1: {
                return A;
            }
            case 2: {
                return NS;
            }
            case 5: {
                return CNAME;
            }
            case 6: {
                return SOA;
            }
            case 11: {
                return WKS;
            }
            case 12: {
                return PTR;
            }
            case 15: {
                return MX;
            }
            case 16: {
                return TXT;
            }
            case 28: {
                return AAAA;
            }
            case 33: {
                return SRV;
            }
            case 251: {
                return IXFR;
            }
            case 252: {
                return AXFR;
            }
            case 255: {
                return ALL;
            }
            case 256: {
                return URI;
            }
        }
        return Unknown;
    }

    public static QTYPE getQTYPEByName(String name) {
        QTYPE[] qtypes;
        for (QTYPE qtype : qtypes = QTYPE.values()) {
            if (!qtype.name().equalsIgnoreCase(name)) continue;
            return qtype;
        }
        throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684QTYPE\u7c7b\u578b!\u5f53\u524d\u503c:" + name);
    }
}

