/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdns.dns.domain.resourceRecord;

import cn.schoolwow.quickdns.dns.DNSServerUtil;
import cn.schoolwow.quickdns.dns.domain.question.Question;
import cn.schoolwow.quickdns.dns.stream.DNSStream;
import cn.schoolwow.quickdns.dns.stream.DNSStreamImpl;
import cn.schoolwow.quickdns.util.IPUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Map;

public class ResourceRecord
extends Question {
    public int TTL = 600;
    public byte[] RDATA;
    public String RDATAFormat;

    public ResourceRecord(Question question) {
        this.qName = question.qName;
        this.qType = question.qType;
        this.qClass = question.qClass;
    }

    public static ResourceRecord readResourceRecord(DNSStream dnsStream, byte[] rawData, Map<Integer, String> offsetStringCache) throws IOException {
        Question question = ResourceRecord.readQuestion(dnsStream, rawData, offsetStringCache);
        ResourceRecord resourceRecord = new ResourceRecord(question);
        resourceRecord.TTL = dnsStream.readInt();
        int length = dnsStream.readUnsignedShort();
        resourceRecord.RDATA = new byte[length];
        if (length == 0) {
            return resourceRecord;
        }
        dnsStream.read(resourceRecord.RDATA, 0, length);
        ByteArrayInputStream bais = new ByteArrayInputStream(resourceRecord.RDATA);
        DNSStreamImpl rDataStream = new DNSStreamImpl(bais);
        switch (resourceRecord.qType) {
            case CNAME: 
            case NS: 
            case PTR: {
                String RDATAFormat;
                resourceRecord.RDATAFormat = RDATAFormat = ResourceRecord.readDomainName(rDataStream, rawData, offsetStringCache);
                break;
            }
            case TXT: {
                String RDATAFormat;
                resourceRecord.RDATAFormat = RDATAFormat = ResourceRecord.readCharacterString(rDataStream);
                break;
            }
            case A: 
            case AAAA: {
                String ip = InetAddress.getByAddress(resourceRecord.RDATA).toString();
                resourceRecord.RDATAFormat = ip.substring(ip.indexOf(47) + 1).trim();
                break;
            }
            case SOA: {
                JSONObject o = new JSONObject();
                o.put("mname", (Object)ResourceRecord.readDomainName(rDataStream, rawData, offsetStringCache));
                o.put("rname", (Object)ResourceRecord.readDomainName(rDataStream, rawData, offsetStringCache));
                o.put("serial", (Object)rDataStream.readInt());
                o.put("refresh", (Object)rDataStream.readInt());
                o.put("retry", (Object)rDataStream.readInt());
                o.put("expire", (Object)rDataStream.readInt());
                resourceRecord.RDATAFormat = o.toJSONString();
                break;
            }
            case MX: {
                JSONObject o = new JSONObject();
                o.put("preference", (Object)rDataStream.readShort());
                o.put("exchange", (Object)ResourceRecord.readDomainName(rDataStream, rawData, offsetStringCache));
                resourceRecord.RDATAFormat = o.toJSONString();
                break;
            }
            default: {
                resourceRecord.RDATAFormat = "[" + DNSServerUtil.byteArrayToHex(resourceRecord.RDATA) + "]";
            }
        }
        return resourceRecord;
    }

    public static void writeResourceRecord(DNSStream dnsStream, ResourceRecord resourceRecord, Map<String, Integer> offsetStringCache) throws IOException {
        ResourceRecord.writeQuestion(dnsStream, resourceRecord, offsetStringCache);
        dnsStream.writeInt(resourceRecord.TTL);
        if (null == resourceRecord.RDATAFormat || resourceRecord.RDATAFormat.startsWith("[")) {
            logger.warn("\u6682\u4e0d\u652f\u6301\u683c\u5f0f\u5316\u8be5DNS\u7c7b\u578b!\u5f53\u524dDNS\u7c7b\u578b:" + (Object)((Object)resourceRecord.qType) + ",\u539f\u59cb\u503c:" + resourceRecord.RDATAFormat);
            dnsStream.writeShort(resourceRecord.RDATA.length);
            dnsStream.write(resourceRecord.RDATA);
            return;
        }
        switch (resourceRecord.qType) {
            case CNAME: 
            case NS: 
            case PTR: {
                int rDataLength = ResourceRecord.calculateDomainNameLength(resourceRecord.RDATAFormat, offsetStringCache);
                dnsStream.writeShort(rDataLength);
                ResourceRecord.writeDomainName(dnsStream, resourceRecord.RDATAFormat, offsetStringCache);
                break;
            }
            case TXT: {
                int rDataLength = 1 + resourceRecord.RDATAFormat.length();
                dnsStream.writeShort(rDataLength);
                ResourceRecord.writeCharacterString(dnsStream, resourceRecord.RDATAFormat);
                break;
            }
            case A: 
            case AAAA: {
                byte[] bytes = IPUtil.ipToBytes(resourceRecord.RDATAFormat);
                dnsStream.writeShort(bytes.length);
                dnsStream.write(bytes);
                break;
            }
            case MX: {
                JSONObject o = JSON.parseObject(resourceRecord.RDATAFormat);
                int rDataLength = ResourceRecord.calculateDomainNameLength(o.getString("exchange"), offsetStringCache);
                dnsStream.writeShort(2 + rDataLength);
                dnsStream.writeShort(o.getShort("preference").shortValue());
                ResourceRecord.writeDomainName(dnsStream, o.getString("exchange"), offsetStringCache);
                break;
            }
            case SOA: {
                JSONObject o = JSON.parseObject(resourceRecord.RDATAFormat);
                int rDataLength = ResourceRecord.calculateDomainNameLength(o.getString("mname"), offsetStringCache);
                dnsStream.writeShort(16 + (rDataLength += ResourceRecord.calculateDomainNameLength(o.getString("rname"), offsetStringCache)));
                ResourceRecord.writeDomainName(dnsStream, o.getString("mname"), offsetStringCache);
                ResourceRecord.writeDomainName(dnsStream, o.getString("rname"), offsetStringCache);
                dnsStream.writeInt(o.getIntValue("serial"));
                dnsStream.writeInt(o.getIntValue("refresh"));
                dnsStream.writeInt(o.getIntValue("retry"));
                dnsStream.writeInt(o.getIntValue("expire"));
                break;
            }
            default: {
                dnsStream.writeShort(resourceRecord.RDATA.length);
                dnsStream.write(resourceRecord.RDATA);
            }
        }
    }

    private static int calculateDomainNameLength(String domainName, Map<String, Integer> offsetStringCache) throws IOException {
        int length = 0;
        while (true) {
            if (offsetStringCache.containsKey(domainName)) {
                length += 2;
                break;
            }
            if (!domainName.contains(".")) {
                length += 1 + domainName.length() + 1;
                break;
            }
            String firstDomain = domainName.substring(0, domainName.indexOf("."));
            length += 1 + firstDomain.length();
            domainName = domainName.substring(firstDomain.length() + 1);
        }
        return length;
    }

    @Override
    public String toString() {
        return "{\u67e5\u8be2\u57df\u540d:" + this.qName + ",\u67e5\u8be2\u7c7b\u578b:" + this.qType.name() + ",\u67e5\u8be2\u534f\u8bae\u7c7b:" + this.qClass.name() + ",\u7f13\u5b58\u65f6\u95f4(\u79d2):" + this.TTL + ",\u6570\u636e:" + this.RDATAFormat + "}";
    }
}

