/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdns.dns.stream;

import cn.schoolwow.quickdns.dns.stream.DNSStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DNSStreamImpl
implements DNSStream {
    private Logger logger = LoggerFactory.getLogger(DNSStreamImpl.class);
    private DataInputStream in;
    private OutputStream rawOut;
    private DataOutputStream out;
    private Scanner scanner;

    public DNSStreamImpl(byte[] bytes) {
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        this.in = new DataInputStream(bais);
        this.scanner = new Scanner(this.in);
    }

    public DNSStreamImpl(InputStream in) {
        this.in = new DataInputStream(in);
        this.scanner = new Scanner(this.in);
    }

    public DNSStreamImpl(OutputStream out) {
        this.rawOut = out;
        this.out = new DataOutputStream(out);
    }

    public DNSStreamImpl(InputStream in, OutputStream out) {
        this.in = new DataInputStream(in);
        this.rawOut = out;
        this.out = new DataOutputStream(out);
        this.scanner = new Scanner(this.in);
    }

    @Override
    public int read() throws IOException {
        return this.in.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        int length = this.in.read(b);
        if (length != b.length) {
            throw new IllegalArgumentException("\u8bfb\u53d6\u5b57\u8282\u6570\u7ec4\u5931\u8d25\uff01\u671f\u671b\u8bfb\u53d6\u957f\u5ea6:" + b.length + ",\u5b9e\u9645\u8bfb\u53d6\u957f\u5ea6:" + length);
        }
        return length;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int length = this.in.read(b, off, len);
        if (length != len) {
            throw new IllegalArgumentException("\u8bfb\u53d6\u5b57\u8282\u6570\u7ec4\u5931\u8d25\uff01\u671f\u671b\u8bfb\u53d6\u957f\u5ea6:" + len + ",\u5b9e\u9645\u8bfb\u53d6\u957f\u5ea6:" + length);
        }
        return length;
    }

    @Override
    public byte[] readByteArray(int length) throws IOException {
        byte[] buffer = new byte[8192];
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int actualLength = 0;
        int totalLength = length;
        while ((actualLength = this.in.read(buffer, 0, Math.min(buffer.length, totalLength))) != 0) {
            baos.write(buffer, 0, actualLength);
            totalLength -= actualLength;
        }
        if (baos.size() != length) {
            throw new IllegalArgumentException("\u8bfb\u53d6\u6307\u5b9a\u957f\u5ea6\u5b57\u8282\u5931\u8d25!\u671f\u671b\u5b57\u8282\u957f\u5ea6:" + length + ",\u5f53\u524d\u5b57\u8282\u957f\u5ea6:" + baos.size());
        }
        return baos.toByteArray();
    }

    @Override
    public int[] readBitByte() throws IOException {
        return this.readBitByte(1);
    }

    @Override
    public int[] readBitByte(int nByte) throws IOException {
        int[] bits = new int[nByte * 8];
        for (int i = 0; i < nByte; ++i) {
            int b = this.in.read();
            if (b == -1) {
                throw new IOException("\u8f93\u5165\u6d41\u8bfb\u53d6\u5230\u672b\u5c3e\u4e86!");
            }
            for (int j = 0; j < 8; ++j) {
                int n = 1 << 7 - j;
                int result = b & n;
                bits[i * 8 + j] = result == n ? 1 : 0;
            }
        }
        return bits;
    }

    @Override
    public DNSStream writeLine(String line) throws IOException {
        this.out.write((line + "\r\n").getBytes());
        return this;
    }

    @Override
    public void writeBit(int[] bits) throws IOException {
        if (bits.length % 8 != 0) {
            throw new IllegalArgumentException("bits\u53c2\u6570\u957f\u5ea6\u5fc5\u987b\u4e3a8\u7684\u500d\u6570!");
        }
        int byteCount = bits.length / 8;
        for (int i = 0; i < byteCount; ++i) {
            int b = 0;
            for (int j = 0; j < 8; ++j) {
                b |= bits[i * 8 + j] << 7 - j;
            }
            this.write(b);
        }
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public int size() {
        return this.out.size();
    }

    @Override
    public OutputStream getRawOutputStream() {
        return this.rawOut;
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.in.readFully(b);
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        this.in.readFully(b, off, len);
    }

    @Override
    public int skipBytes(int n) throws IOException {
        return this.in.skipBytes(n);
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.in.readBoolean();
    }

    @Override
    public byte readByte() throws IOException {
        return this.in.readByte();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return this.in.readUnsignedByte();
    }

    @Override
    public short readShort() throws IOException {
        return this.in.readShort();
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return this.in.readUnsignedShort();
    }

    @Override
    public char readChar() throws IOException {
        return this.in.readChar();
    }

    @Override
    public int readInt() throws IOException {
        return this.in.readInt();
    }

    @Override
    public long readLong() throws IOException {
        return this.in.readLong();
    }

    @Override
    public float readFloat() throws IOException {
        return this.in.readFloat();
    }

    @Override
    public double readDouble() throws IOException {
        return this.in.readDouble();
    }

    @Override
    public String readLine() throws IOException {
        return this.scanner.nextLine();
    }

    @Override
    public String readUTF() throws IOException {
        return this.in.readUTF();
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.out.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        this.out.writeBoolean(v);
    }

    @Override
    public void writeByte(int v) throws IOException {
        this.out.writeByte(v);
    }

    @Override
    public void writeShort(int v) throws IOException {
        this.out.writeShort(v);
    }

    @Override
    public void writeChar(int v) throws IOException {
        this.out.writeChar(v);
    }

    @Override
    public void writeInt(int v) throws IOException {
        this.out.writeInt(v);
    }

    @Override
    public void writeLong(long v) throws IOException {
        this.out.writeLong(v);
    }

    @Override
    public void writeFloat(float v) throws IOException {
        this.out.writeFloat(v);
    }

    @Override
    public void writeDouble(double v) throws IOException {
        this.out.writeDouble(v);
    }

    @Override
    public void writeBytes(String s) throws IOException {
        this.out.writeBytes(s);
    }

    @Override
    public void writeChars(String s) throws IOException {
        this.out.writeChars(s);
    }

    @Override
    public void writeUTF(String s) throws IOException {
        this.out.writeUTF(s);
    }
}

