/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdns.install;

import cn.schoolwow.quickdns.config.QuickDNSServerConfig;
import cn.schoolwow.quickdns.domain.AMSResult;
import cn.schoolwow.quickdns.install.http.HttpHandler;
import cn.schoolwow.quickdns.install.http.HttpRequest;
import cn.schoolwow.quickdns.install.http.HttpResponse;
import cn.schoolwow.quickdns.install.http.HttpServerBuilder;
import cn.schoolwow.quickdns.util.CommonUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.concurrent.CountDownLatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class InstallServerCommand {
    private static Logger logger = LoggerFactory.getLogger(InstallServerCommand.class);
    private static HttpServer httpServer;

    public static void startInstallServer(int port, final CountDownLatch countDownLatch) throws IOException {
        httpServer = new HttpServerBuilder().port(port).handler("/", new HttpHandler(){

            @Override
            public HttpResponse handle(HttpRequest httpRequest) throws Exception {
                HttpResponse httpResponse = HttpResponse.newInstance();
                String path = httpRequest.uri.getPath();
                if (path.endsWith(".html")) {
                    httpResponse.header("Content-Type", "text/html; charset=utf-8");
                    byte[] body = CommonUtil.getResourceByPath("/static/install" + path);
                    if (null == body) {
                        return httpResponse.redirect("/install.html");
                    }
                    httpResponse.body(body);
                    return httpResponse;
                }
                if (httpRequest.uri.getPath().endsWith(".css")) {
                    httpResponse.header("Content-Type", "text/css; charset=utf-8");
                } else if (httpRequest.uri.getPath().endsWith(".js")) {
                    httpResponse.header("Content-Type", "application/x-javascript; charset=utf-8");
                } else {
                    httpResponse.header("Content-Type", "application/octet-stream");
                }
                byte[] body = CommonUtil.getResourceByPath("/static/quickdns" + path);
                if (null == body) {
                    return httpResponse.redirect("/install.html");
                }
                httpResponse.body(body);
                return httpResponse;
            }
        }).handler("/install.html", new HttpHandler(){

            @Override
            public HttpResponse handle(HttpRequest httpRequest) throws Exception {
                HttpResponse httpResponse = HttpResponse.newInstance();
                httpResponse.header("Content-Type", "text/html; charset=utf-8");
                httpResponse.body(CommonUtil.getResourceByPath("/static/install/install.html"));
                return httpResponse;
            }
        }).handler("/install/read", new HttpHandler(){

            @Override
            public HttpResponse handle(HttpRequest httpRequest) throws Exception {
                JSONObject data = new JSONObject();
                data.put("sqliteFilePath", (Object)(System.getProperty("user.dir").replace("\\", "/") + "/QuickDNS.db"));
                return HttpResponse.newInstance().header("Content-Type", "application/json; charset=utf-8").body(AMSResult.success(data));
            }
        }).handler("/install/testConnection", new HttpHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public HttpResponse handle(HttpRequest httpRequest) throws Exception {
                JSONObject parameter = JSON.parseObject(httpRequest.body);
                QuickDNSServerConfig.quickDNSConfigProperties.username = parameter.getString("username");
                QuickDNSServerConfig.quickDNSConfigProperties.password = parameter.getString("password");
                String url = parameter.getString("ip") + ":" + parameter.getString("port") + "/";
                switch (parameter.getString("databaseType")) {
                    case "sqlite": {
                        QuickDNSServerConfig.quickDNSConfigProperties.driverClassName = "org.sqlite.JDBC";
                        QuickDNSServerConfig.quickDNSConfigProperties.jdbcUrl = "jdbc:sqlite://" + parameter.getString("sqliteFilePath");
                        break;
                    }
                    case "mysql": {
                        QuickDNSServerConfig.quickDNSConfigProperties.driverClassName = "com.mysql.jdbc.Driver";
                        QuickDNSServerConfig.quickDNSConfigProperties.jdbcUrl = "jdbc:mysql://" + url;
                        break;
                    }
                    case "mariadb": {
                        QuickDNSServerConfig.quickDNSConfigProperties.driverClassName = "org.mariadb.jdbc.Driver";
                        QuickDNSServerConfig.quickDNSConfigProperties.jdbcUrl = "jdbc:mariadb://" + url;
                        break;
                    }
                    case "postgre": {
                        QuickDNSServerConfig.quickDNSConfigProperties.driverClassName = "org.postgresql.Driver";
                        QuickDNSServerConfig.quickDNSConfigProperties.jdbcUrl = "jdbc:postgresql://" + url;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u6570\u636e\u5e93\u7c7b\u578b!\u5f53\u524d\u6570\u636e\u5e93\u7c7b\u578b:" + parameter.getString("databaseType"));
                    }
                }
                Class.forName(QuickDNSServerConfig.quickDNSConfigProperties.driverClassName);
                Connection connection = null;
                AMSResult amsResult = AMSResult.success();
                try {
                    connection = StringUtils.isEmpty(QuickDNSServerConfig.quickDNSConfigProperties.username) && StringUtils.isEmpty(QuickDNSServerConfig.quickDNSConfigProperties.password) ? DriverManager.getConnection(QuickDNSServerConfig.quickDNSConfigProperties.jdbcUrl) : DriverManager.getConnection(QuickDNSServerConfig.quickDNSConfigProperties.jdbcUrl, QuickDNSServerConfig.quickDNSConfigProperties.username, QuickDNSServerConfig.quickDNSConfigProperties.password);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    amsResult = AMSResult.fail("\u6570\u636e\u5e93\u8fde\u63a5\u5931\u8d25!" + e.getMessage());
                }
                finally {
                    if (null != connection) {
                        connection.close();
                    }
                }
                if (!"sqlite".equals(parameter.getString("databaseType"))) {
                    QuickDNSServerConfig.quickDNSConfigProperties.jdbcUrl = QuickDNSServerConfig.quickDNSConfigProperties.jdbcUrl + parameter.getString("databaseName");
                }
                return HttpResponse.newInstance().body(amsResult);
            }
        }).handler("/install/update", new HttpHandler(){

            @Override
            public HttpResponse handle(HttpRequest httpRequest) throws Exception {
                JSONObject parameter = JSON.parseObject(httpRequest.body);
                QuickDNSServerConfig.quickDNSConfigProperties.gatewayIp = parameter.getString("gatewayIp");
                QuickDNSServerConfig.quickDNSConfigProperties.dnsQueryTimeoutSeconds = parameter.getIntValue("dnsQueryTimeoutSeconds");
                QuickDNSServerConfig.quickDNSConfigProperties.webListenPort = parameter.getIntValue("webListenPort");
                QuickDNSServerConfig.quickDNSConfigProperties.dnsListenPort = parameter.getIntValue("dnsListenPort");
                QuickDNSServerConfig.quickDNSConfigProperties.initialPassword = parameter.getString("initialPassword");
                AMSResult amsResult = AMSResult.success();
                if (CommonUtil.hasPortUsed("0.0.0.0", QuickDNSServerConfig.quickDNSConfigProperties.webListenPort)) {
                    amsResult = AMSResult.fail("Web\u7aef\u53e3\u5df2\u7ecf\u88ab\u5360\u7528!\u5f53\u524d\u6307\u5b9aWeb\u7aef\u53e3:" + QuickDNSServerConfig.quickDNSConfigProperties.webListenPort);
                } else if (CommonUtil.hasPortUsed("0.0.0.0", QuickDNSServerConfig.quickDNSConfigProperties.dnsListenPort)) {
                    amsResult = AMSResult.fail("DNS\u7aef\u53e3\u5df2\u7ecf\u88ab\u5360\u7528!\u5f53\u524d\u6307\u5b9aDNS\u7aef\u53e3:" + QuickDNSServerConfig.quickDNSConfigProperties.dnsListenPort);
                } else if (CommonUtil.getDNSConsumeTime(QuickDNSServerConfig.quickDNSConfigProperties.gatewayIp, 53) < 0) {
                    amsResult = AMSResult.fail("\u65e0\u6cd5\u8fde\u63a5\u5230\u7f51\u5173DNS\u670d\u52a1\u5668!\u5f53\u524d\u6307\u5b9a\u7f51\u5173IP\u5730\u5740:" + QuickDNSServerConfig.quickDNSConfigProperties.gatewayIp + ":53");
                }
                return HttpResponse.newInstance().body(amsResult);
            }
        }).handler("/install/complete", new HttpHandler(){

            @Override
            public HttpResponse handle(HttpRequest httpRequest) throws Exception {
                QuickDNSServerConfig.quickDNSConfigProperties.jdbcUrl = QuickDNSServerConfig.quickDNSConfigProperties.jdbcUrl.replace("\\", "/");
                String configProperties = JSON.toJSONString(QuickDNSServerConfig.quickDNSConfigProperties);
                String configFilePath = System.getProperty("user.dir") + "/config.json";
                Path configPath = Paths.get(configFilePath, new String[0]);
                Files.createDirectories(configPath.getParent(), new FileAttribute[0]);
                Files.deleteIfExists(configPath);
                logger.info("[\u5199\u5165\u914d\u7f6e\u6587\u4ef6]\u8def\u5f84:{},\u503c:{}", (Object)configFilePath, (Object)configProperties);
                Files.write(configPath, configProperties.getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE, StandardOpenOption.WRITE);
                countDownLatch.countDown();
                new Thread(() -> {
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    finally {
                        if (null != httpServer) {
                            httpServer.stop(0);
                        }
                        System.out.println("\u7ed3\u675f\u5b89\u88c5\u670d\u52a1!");
                    }
                }).start();
                String content = new String(CommonUtil.getResourceByPath("/static/install/redirect.html"), StandardCharsets.UTF_8);
                content = content.replace("{{redirectUrl}}", httpRequest.data.get("url") + ":" + QuickDNSServerConfig.quickDNSConfigProperties.webListenPort + "/#/queryList");
                return HttpResponse.newInstance().header("Content-Type", "text/html; charset=utf-8").body(content);
            }
        }).build();
        logger.info("[\u542f\u52a8QuickDNS\u5b89\u88c5\u670d\u52a1]\u8bf7\u901a\u8fc7http\u534f\u8bae\u8bbf\u95ee\u672c\u673a" + port + "\u7aef\u53e3!");
        httpServer.start();
    }
}

