/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdns.install.http;

import cn.schoolwow.quickdns.domain.AMSResult;
import cn.schoolwow.quickdns.install.http.HttpHandler;
import cn.schoolwow.quickdns.install.http.HttpRequest;
import cn.schoolwow.quickdns.install.http.HttpResponse;
import com.alibaba.fastjson.JSON;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpServer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpServerBuilder {
    private Logger logger = LoggerFactory.getLogger(HttpServerBuilder.class);
    private HttpServerMockConfig httpServerMockConfig = new HttpServerMockConfig();

    public HttpServerBuilder port(int port) {
        this.httpServerMockConfig.port = port;
        return this;
    }

    public HttpServerBuilder handler(String url, HttpHandler handler) {
        this.httpServerMockConfig.handlerMap.put(url, handler);
        return this;
    }

    public HttpServerBuilder threadPoolExecutor(ThreadPoolExecutor threadPoolExecutor) {
        this.httpServerMockConfig.threadPoolExecutor = threadPoolExecutor;
        return this;
    }

    public HttpServer build() throws IOException {
        InetSocketAddress inetSocketAddress = new InetSocketAddress("0.0.0.0", this.httpServerMockConfig.port);
        HttpServer httpServer = HttpServer.create(inetSocketAddress, 0);
        Set<Map.Entry<String, HttpHandler>> entrySet = this.httpServerMockConfig.handlerMap.entrySet();
        for (Map.Entry<String, HttpHandler> entry : entrySet) {
            httpServer.createContext(entry.getKey(), httpExchange -> {
                HttpRequest httpRequest = this.getHttpRequest(httpExchange);
                HttpResponse httpResponse = null;
                try {
                    httpResponse = ((HttpHandler)entry.getValue()).handle(httpRequest);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    httpResponse = HttpResponse.newInstance().statusCode(200).body(JSON.toJSONString(AMSResult.fail(e.getMessage())));
                }
                if (null == httpResponse) {
                    httpResponse = HttpResponse.newInstance().statusCode(404);
                }
                httpExchange.getResponseHeaders().putAll((Map<? extends String, ? extends List<String>>)httpResponse.httpResponseMockConfig.responseHeader);
                long length = 0L;
                if (null != httpResponse.httpResponseMockConfig.body && httpResponse.httpResponseMockConfig.body.length > 0) {
                    length = httpResponse.httpResponseMockConfig.body.length;
                }
                httpExchange.sendResponseHeaders(httpResponse.httpResponseMockConfig.statusCode, length);
                if (null != httpResponse.httpResponseMockConfig.body && httpResponse.httpResponseMockConfig.body.length > 0) {
                    OutputStream outputStream = httpExchange.getResponseBody();
                    outputStream.write(httpResponse.httpResponseMockConfig.body);
                    outputStream.flush();
                    outputStream.close();
                }
                httpExchange.close();
            });
        }
        if (null == this.httpServerMockConfig.threadPoolExecutor) {
            this.httpServerMockConfig.threadPoolExecutor = (ThreadPoolExecutor)Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        }
        httpServer.setExecutor(this.httpServerMockConfig.threadPoolExecutor);
        return httpServer;
    }

    private HttpRequest getHttpRequest(HttpExchange httpExchange) throws IOException {
        HttpRequest httpRequest = new HttpRequest();
        httpRequest.uri = httpExchange.getRequestURI();
        this.handleFormData(httpRequest.uri.getRawQuery(), httpRequest.data);
        httpRequest.requestMethod = httpExchange.getRequestMethod();
        httpRequest.headers.putAll(httpExchange.getRequestHeaders());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        InputStream in = httpExchange.getRequestBody();
        byte[] buffer = new byte[8192];
        int length = 0;
        while ((length = in.read(buffer, 0, buffer.length)) != -1) {
            baos.write(buffer, 0, length);
        }
        httpRequest.bodyBytes = baos.toByteArray();
        httpRequest.body = new String(httpRequest.bodyBytes, StandardCharsets.UTF_8);
        if (httpRequest.headers.containsKey("Content-Type") && httpRequest.headers.get("Content-Type").get(0).contains("application/x-www-form-urlencoded")) {
            this.handleFormData(httpRequest.body, httpRequest.data);
        }
        this.logger.debug("[HTTP\u6a21\u62df\u670d\u52a1\u5668\u6536\u5230\u8bf7\u6c42]{} {}\n{}\n\n{}", httpRequest.requestMethod, httpRequest.uri, httpRequest.headers, httpRequest.body);
        return httpRequest;
    }

    private void handleFormData(String rawValue, Map<String, String> data) {
        if (null == rawValue || rawValue.isEmpty()) {
            return;
        }
        StringTokenizer st = new StringTokenizer(rawValue, "&");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.contains("=")) {
                String key = token.substring(0, token.indexOf("="));
                String value = token.substring(token.indexOf("=") + 1);
                data.put(key, value);
                continue;
            }
            data.put(token, "");
        }
    }

    private class HttpServerMockConfig {
        public int port;
        public Map<String, HttpHandler> handlerMap = new HashMap<String, HttpHandler>();
        public ThreadPoolExecutor threadPoolExecutor;

        private HttpServerMockConfig() {
        }
    }
}

