/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdns.util;

import cn.schoolwow.quickdns.dns.DNSServerUtil;
import cn.schoolwow.quickdns.dns.domain.DNSRequest;
import cn.schoolwow.quickdns.dns.domain.DNSResponse;
import cn.schoolwow.quickdns.dns.domain.question.Question;
import cn.schoolwow.quickdns.dns.domain.question.constants.QTYPE;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.JarURLConnection;
import java.net.Socket;
import java.net.URL;
import java.nio.file.Files;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonUtil {
    private static Logger logger = LoggerFactory.getLogger(CommonUtil.class);

    public static int getDNSConsumeTime(String ip, int port) {
        try {
            long startTime = System.currentTimeMillis();
            Question question = new Question("baidu.com", QTYPE.A);
            DNSResponse dnsResponse = DNSServerUtil.sendDNSRequest(ip, port, new DNSRequest(question));
            long endTime = System.currentTimeMillis();
            if (null != dnsResponse) {
                logger.info("[\u53ef\u4ee5\u6b63\u5e38\u8fde\u63a5\u7f51\u5173DNS\u670d\u52a1]\u7f51\u5173IP:{}, \u67e5\u8be2\u95ee\u9898:baidu.com, \u8fd4\u56de\u62a5\u6587:{}", (Object)(ip + ":" + port), (Object)dnsResponse);
                return (int)(endTime - startTime);
            }
        }
        catch (Exception e) {
            logger.warn("\u65e0\u6cd5\u8fde\u63a5\u7f51\u5173DNS\u670d\u52a1!\u539f\u56e0:{}, \u7f51\u5173IP:{}", (Object)e.getMessage(), (Object)(ip + ":" + port));
            return -1;
        }
        return -1;
    }

    public static boolean hasPortUsed(String ip, int port) {
        boolean flag = false;
        try {
            InetAddress inetAddress = InetAddress.getByName(ip);
            InetSocketAddress inetSocketAddress = new InetSocketAddress(inetAddress, port);
            Socket socket = new Socket();
            socket.connect(inetSocketAddress, 1000);
            flag = true;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return flag;
    }

    public static byte[] getResourceByPath(String path) throws IOException {
        URL url = CommonUtil.class.getResource(path);
        if (null == url) {
            logger.warn("[\u8d44\u6e90\u8def\u5f84\u4e0d\u5b58\u5728]{}", (Object)path);
            return null;
        }
        switch (url.getProtocol()) {
            case "file": {
                File file = new File(url.getFile());
                if (file.isFile()) {
                    logger.trace("[\u6587\u4ef6\u8d44\u6e90]\u8def\u5f84:{}", (Object)file.getAbsolutePath());
                    return Files.readAllBytes(file.toPath());
                }
                logger.warn("[\u6587\u4ef6\u8d44\u6e90\u4e0d\u5b58\u5728]\u8bf7\u6c42\u8def\u5f84:{}, \u6587\u4ef6\u8def\u5f84:{}", (Object)path, (Object)file.getAbsolutePath());
                break;
            }
            case "jar": {
                JarEntry jarEntry;
                JarURLConnection jarURLConnection = (JarURLConnection)url.openConnection();
                JarFile jarFile = jarURLConnection.getJarFile();
                if (path.startsWith("/")) {
                    path = path.substring(1);
                }
                if ((jarEntry = jarFile.getJarEntry(path)) == null || jarEntry.isDirectory()) {
                    logger.warn("[jar\u8d44\u6e90]jar\u6587\u4ef6\u4e0d\u5b58\u5728\u6216\u8005\u4e3a\u6587\u4ef6\u5939,\u8def\u5f84:{},jarEntry:{}", (Object)path, (Object)jarEntry);
                    break;
                }
                InputStream inputStream = jarFile.getInputStream(jarEntry);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] buffer = new byte[8192];
                int length = 0;
                while ((length = inputStream.read(buffer, 0, buffer.length)) != -1) {
                    baos.write(buffer, 0, length);
                }
                return baos.toByteArray();
            }
        }
        return null;
    }
}

