/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdns.util;

import java.util.Arrays;

public class IPUtil {
    public static boolean internalIp(byte[] addr) {
        byte b0 = addr[0];
        byte b1 = addr[1];
        int SECTION_0 = 127;
        int SECTION_1 = 10;
        int SECTION_2 = -84;
        int SECTION_3 = 16;
        int SECTION_4 = 31;
        int SECTION_5 = -64;
        int SECTION_6 = -88;
        switch (b0) {
            case 127: {
                return addr[1] == 0 && addr[2] == 0 && addr[3] == 1;
            }
            case 10: {
                return true;
            }
            case -84: {
                if (b1 >= 16 && b1 <= 31) {
                    return true;
                }
            }
            case -64: {
                switch (b1) {
                    case -88: {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public static byte[] ipToBytes(String ip) {
        byte[] bytes = (ip = ip.replace(" ", "")).contains(":") ? IPUtil.ipv6ToBytes(ip) : IPUtil.ipv4ToBytes(ip);
        return Arrays.copyOfRange(bytes, 1, bytes.length);
    }

    private static byte[] ipv6ToBytes(String ipv6) {
        byte[] ret = new byte[17];
        ret[0] = 0;
        int ib = 16;
        boolean comFlag = false;
        if (ipv6.startsWith(":")) {
            ipv6 = ipv6.substring(1);
        }
        String[] groups = ipv6.split(":");
        for (int ig = groups.length - 1; ig > -1; --ig) {
            if (groups[ig].contains(".")) {
                byte[] temp = IPUtil.ipv4ToBytes(groups[ig]);
                ret[ib--] = temp[4];
                ret[ib--] = temp[3];
                ret[ib--] = temp[2];
                ret[ib--] = temp[1];
                comFlag = true;
                continue;
            }
            if ("".equals(groups[ig])) {
                int zlg = 9 - (groups.length + (comFlag ? 1 : 0));
                while (zlg-- > 0) {
                    ret[ib--] = 0;
                    ret[ib--] = 0;
                }
                continue;
            }
            int temp = Integer.parseInt(groups[ig], 16);
            ret[ib--] = (byte)temp;
            ret[ib--] = (byte)(temp >> 8);
        }
        return ret;
    }

    private static byte[] ipv4ToBytes(String ipv4) {
        byte[] ret = new byte[5];
        ret[0] = 0;
        int position1 = ipv4.indexOf(".");
        int position2 = ipv4.indexOf(".", position1 + 1);
        int position3 = ipv4.indexOf(".", position2 + 1);
        ret[1] = (byte)Integer.parseInt(ipv4.substring(0, position1));
        ret[2] = (byte)Integer.parseInt(ipv4.substring(position1 + 1, position2));
        ret[3] = (byte)Integer.parseInt(ipv4.substring(position2 + 1, position3));
        ret[4] = (byte)Integer.parseInt(ipv4.substring(position3 + 1));
        return ret;
    }
}

