/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdns.util;

import cn.schoolwow.quickdns.entity.DNSForwardServer;
import cn.schoolwow.quickdns.entity.DNSRecord;

public class ValidateUtil {
    public static void validateDNSRecord(DNSRecord dnsRecord) {
        switch (dnsRecord.getType()) {
            case "A": {
                ValidateUtil.validateRegexPattern("\u8bb0\u5f55\u503c\u5fc5\u987b\u4e3a\u5408\u6cd5\u7684ipv4\u5730\u5740!", dnsRecord.getValue(), "(?:(?:1[0-9][0-9]\\.)|(?:2[0-4][0-9]\\.)|(?:25[0-5]\\.)|(?:[1-9][0-9]\\.)|(?:[0-9]\\.)){3}(?:(?:1[0-9][0-9])|(?:2[0-4][0-9])|(?:25[0-5])|(?:[1-9][0-9])|(?:[0-9]))");
                break;
            }
            case "AAAA": {
                ValidateUtil.validateRegexPattern("\u8bb0\u5f55\u503c\u5fc5\u987b\u4e3a\u5408\u6cd5\u7684ipv6\u5730\u5740!", dnsRecord.getValue(), "^([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}$", "^(([0-9A-Fa-f]{1,4}(:[0-9A-Fa-f]{1,4})*)?)::((([0-9A-Fa-f]{1,4}:)*[0-9A-Fa-f]{1,4})?)$");
            }
        }
    }

    public static void validateDNSForwardServer(DNSForwardServer dnsForwardServer) {
        ValidateUtil.validateRegexPattern("\u8bb0\u5f55\u503c\u5fc5\u987b\u4e3a\u5408\u6cd5\u7684ipv4\u5730\u5740!", dnsForwardServer.getIpv4(), "(?:(?:1[0-9][0-9]\\.)|(?:2[0-4][0-9]\\.)|(?:25[0-5]\\.)|(?:[1-9][0-9]\\.)|(?:[0-9]\\.)){3}(?:(?:1[0-9][0-9])|(?:2[0-4][0-9])|(?:25[0-5])|(?:[1-9][0-9])|(?:[0-9]))");
    }

    public static void validateRegexPattern(String message, String value, String ... patterns) {
        for (String pattern : patterns) {
            if (!value.matches(pattern)) continue;
            return;
        }
        throw new IllegalArgumentException(message);
    }
}

