/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickhttp.document.parser;

import cn.schoolwow.quickhttp.document.parser.HTMLToken;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTMLParser {
    private Logger logger = LoggerFactory.getLogger(HTMLParser.class);
    private static final String[] singleNodeList = new String[]{"br", "hr", "img", "input", "param", "meta", "link", "!doctype", "?xml", "col"};
    private char[] chars;
    private int pos = 0;
    private int sectionStart = 0;
    private int lastTokenPos = -1;
    private String currentTagName;
    private State state = State.openingTag;
    private List<HTMLToken> tokenList = new ArrayList<HTMLToken>();

    public static List<HTMLToken> parse(String html) {
        return new HTMLParser((String)html).tokenList;
    }

    private HTMLParser(String html) {
        this.chars = html.toCharArray();
        this.parseHTML();
    }

    private void parseHTML() {
        while (this.pos < this.chars.length) {
            switch (this.state) {
                case openingTag: {
                    if (this.isLastMatch("<!--")) {
                        this.state = State.inComment;
                        this.addToken(HTMLToken.TokenType.openTag);
                        break;
                    }
                    if (!this.isLastMatch("<") || this.isNextMatch("!--")) break;
                    this.state = State.inTagName;
                    this.addToken(HTMLToken.TokenType.openTag);
                    break;
                }
                case inTagName: {
                    if (this.isNextMatch("/>")) {
                        this.currentTagName = this.addToken(HTMLToken.TokenType.tagName);
                        this.state = State.closingTag;
                        break;
                    }
                    if (this.chars[this.pos] == '>') {
                        this.currentTagName = this.addToken(HTMLToken.TokenType.tagName);
                        if (HTMLParser.isSingleNode(this.currentTagName)) {
                            this.state = State.closingTag;
                            break;
                        }
                        this.state = State.openTagClosing;
                        break;
                    }
                    if (Character.isLetterOrDigit((int)this.chars[this.pos])) break;
                    this.currentTagName = this.addToken(HTMLToken.TokenType.tagName);
                    this.state = State.inAttribute;
                    break;
                }
                case inComment: {
                    if (!this.isNextMatch("-->")) break;
                    this.addToken(HTMLToken.TokenType.commentTag);
                    this.state = State.closingTag;
                    break;
                }
                case inAttribute: {
                    if (this.chars[this.pos] == '\"') {
                        this.state = State.inAttributeDoubleQuote;
                        break;
                    }
                    if (this.chars[this.pos] == '\'') {
                        this.state = State.inAttributeSingleQuote;
                        break;
                    }
                    if (this.isNextMatch("/>")) {
                        this.addToken(HTMLToken.TokenType.attribute);
                        this.state = State.closingTag;
                        break;
                    }
                    if (!this.isNextMatch(">")) break;
                    this.addToken(HTMLToken.TokenType.attribute);
                    if (HTMLParser.isSingleNode(this.currentTagName)) {
                        this.state = State.closingTag;
                        if (this.pos != this.chars.length - 1) break;
                        this.addToken(HTMLToken.TokenType.closeTag);
                        break;
                    }
                    this.state = State.openTagClosing;
                    break;
                }
                case inAttributeSingleQuote: {
                    if (this.pos == this.chars.length - 1 && this.lastTokenPos > 0) {
                        this.pos = this.lastTokenPos;
                        this.addToken(HTMLToken.TokenType.attribute);
                        this.state = HTMLParser.isSingleNode(this.currentTagName) ? State.closingTag : State.openTagClosing;
                        this.lastTokenPos = -1;
                        break;
                    }
                    if (this.chars[this.pos] == '\'') {
                        this.state = State.inAttribute;
                        break;
                    }
                    if (this.lastTokenPos != -1 || this.chars[this.pos] != '>') break;
                    this.lastTokenPos = this.pos;
                    break;
                }
                case inAttributeDoubleQuote: {
                    if (this.pos == this.chars.length - 1 && this.lastTokenPos > 0) {
                        this.pos = this.lastTokenPos;
                        this.addToken(HTMLToken.TokenType.attribute);
                        this.state = HTMLParser.isSingleNode(this.currentTagName) ? State.closingTag : State.openTagClosing;
                        this.lastTokenPos = -1;
                        break;
                    }
                    if (this.chars[this.pos] == '\"') {
                        this.state = State.inAttribute;
                        break;
                    }
                    if (this.lastTokenPos != -1 || this.chars[this.pos] != '>') break;
                    this.lastTokenPos = this.pos;
                    break;
                }
                case openTagClosing: {
                    this.state = this.isNextMatch("</") ? State.closingTag : (this.chars[this.pos] == '<' ? State.openingTag : ("style".equals(this.currentTagName) || "script".equals(this.currentTagName) ? State.inStyleOrScript : State.inTextContent));
                    this.addToken(HTMLToken.TokenType.openTagClose);
                    break;
                }
                case inStyleOrScript: {
                    if (!this.isNextMatch("</script>") && !this.isNextMatch("</style>")) break;
                    this.addToken(HTMLToken.TokenType.textContent);
                    this.state = State.closingTag;
                    break;
                }
                case inTextContent: {
                    if (this.isNextMatch("</")) {
                        this.addToken(HTMLToken.TokenType.textContent);
                        this.state = State.closingTag;
                        break;
                    }
                    if (this.chars[this.pos] != '<') break;
                    this.addToken(HTMLToken.TokenType.textContent);
                    this.state = State.openingTag;
                    break;
                }
                case closingTag: {
                    if (this.pos == this.chars.length - 1) {
                        this.addToken(HTMLToken.TokenType.closeTag);
                        break;
                    }
                    if (this.isLastMatch(">") && this.isNextMatch("</")) {
                        this.addToken(HTMLToken.TokenType.closeTag);
                        this.state = State.closingTag;
                        break;
                    }
                    if (this.isLastMatch(">") && this.chars[this.pos] == '<') {
                        this.addToken(HTMLToken.TokenType.closeTag);
                        this.state = State.openingTag;
                        break;
                    }
                    if (!this.isLastMatch(">") || this.chars[this.pos] == '<') break;
                    this.addToken(HTMLToken.TokenType.closeTag);
                    this.state = State.inTextContent;
                }
            }
            ++this.pos;
        }
        this.logger.trace("[Token\u5217\u8868]{}", (Object)this.tokenList.toString());
    }

    private String addToken(HTMLToken.TokenType tokenType) {
        HTMLToken token = new HTMLToken();
        token.start = this.sectionStart;
        token.end = this.pos;
        token.tokenType = tokenType;
        if (this.pos == this.sectionStart) {
            token.value = this.chars[this.pos] + "";
        } else {
            int count = token.end - token.start;
            if (this.pos == this.chars.length - 1) {
                ++count;
            }
            token.value = new String(this.chars, token.start, count);
        }
        this.sectionStart = this.pos;
        this.tokenList.add(token);
        return token.value;
    }

    private boolean isLastMatch(String key) {
        int index;
        if (this.pos - key.length() < 0) {
            return false;
        }
        for (index = 0; index < key.length() && this.chars[this.pos - key.length() + index] == key.charAt(index); ++index) {
        }
        return index == key.length();
    }

    private boolean isNextMatch(String key) {
        int index;
        if (this.pos + key.length() > this.chars.length) {
            return false;
        }
        for (index = 0; index < key.length() && this.chars[index + this.pos] == key.charAt(index); ++index) {
        }
        return index == key.length();
    }

    private static boolean isSingleNode(String tagName) {
        for (String singleNode : singleNodeList) {
            if (!tagName.equalsIgnoreCase(singleNode)) continue;
            return true;
        }
        return false;
    }

    private static enum State {
        openingTag,
        inTagName,
        inAttribute,
        inAttributeSingleQuote,
        inAttributeDoubleQuote,
        openTagClosing,
        inStyleOrScript,
        inTextContent,
        closingTag,
        inComment;

    }
}

