/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickhttp.handler;

import cn.schoolwow.quickhttp.domain.LogLevel;
import cn.schoolwow.quickhttp.domain.MetaWrapper;
import cn.schoolwow.quickhttp.domain.QuickHttpConfig;
import cn.schoolwow.quickhttp.handler.AbstractHandler;
import cn.schoolwow.quickhttp.handler.Handler;
import cn.schoolwow.quickhttp.handler.RequestHandler;
import cn.schoolwow.quickhttp.listener.QuickHttpClientListener;
import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DispatcherHandler
extends AbstractHandler {
    private static Logger logger = LoggerFactory.getLogger(DispatcherHandler.class);

    public DispatcherHandler(MetaWrapper metaWrapper) {
        super(metaWrapper);
    }

    @Override
    public Handler handle() throws IOException {
        this.checkRequestMeta();
        List<QuickHttpClientListener> quickHttpClientListenerList = this.clientConfig.quickHttpClientListenerList;
        for (QuickHttpClientListener quickHttpClientListener : quickHttpClientListenerList) {
            quickHttpClientListener.beforeExecute(this.metaWrapper.request);
        }
        try {
            for (int retryTimes = 1; retryTimes <= this.clientConfig.retryTimes; ++retryTimes) {
                try {
                    for (Handler handler = new RequestHandler(this.metaWrapper); null != handler; handler = handler.handle()) {
                    }
                    break;
                }
                catch (ConnectException | SocketTimeoutException e) {
                    this.log(LogLevel.WARN, "[\u94fe\u63a5\u8d85\u65f6]\u91cd\u8bd5{}/{},\u539f\u56e0:{},\u5730\u5740:{}", retryTimes, this.clientConfig.retryTimes, e.getMessage(), this.requestMeta.url);
                    this.requestMeta.connectTimeoutMillis *= 2;
                    this.requestMeta.readTimeoutMillis *= 2;
                    continue;
                }
            }
            for (QuickHttpClientListener quickHttpClientListener : quickHttpClientListenerList) {
                quickHttpClientListener.executeSuccess(this.metaWrapper.request, this.metaWrapper.response);
            }
        }
        catch (Exception e) {
            for (QuickHttpClientListener quickHttpClientListener : quickHttpClientListenerList) {
                quickHttpClientListener.executeFail(this.metaWrapper.request, e);
            }
            throw e;
        }
        finally {
            System.setProperty("sun.net.http.allowRestrictedHeaders", "false");
        }
        return null;
    }

    private void checkRequestMeta() {
        this.log(LogLevel.DEBUG, "\u68c0\u67e5\u8bf7\u6c42\u5143\u6570\u636e!", new Object[0]);
        if (null == this.requestMeta.url) {
            this.log(LogLevel.DEBUG, "url\u4e0d\u80fd\u4e3a\u7a7a!", new Object[0]);
            throw new IllegalArgumentException("url\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        String protocol = this.requestMeta.url.getProtocol();
        if (!protocol.startsWith("http")) {
            this.log(LogLevel.DEBUG, "\u5f53\u524d\u53ea\u652f\u6301http\u548chttps\u534f\u8bae.\u5f53\u524durl:" + this.requestMeta.url, new Object[0]);
            throw new IllegalArgumentException("\u5f53\u524d\u53ea\u652f\u6301http\u548chttps\u534f\u8bae.\u5f53\u524durl:" + this.requestMeta.url);
        }
        if (null == this.requestMeta.proxy) {
            this.requestMeta.proxy = this.clientConfig.proxy;
        }
        if (null == this.requestMeta.proxy) {
            this.requestMeta.proxy = QuickHttpConfig.proxy;
        }
        if (3000 == this.requestMeta.connectTimeoutMillis) {
            this.requestMeta.connectTimeoutMillis = this.clientConfig.connectTimeoutMillis;
        }
        if (5000 == this.requestMeta.readTimeoutMillis) {
            this.requestMeta.readTimeoutMillis = this.clientConfig.readTimeoutMillis;
        }
        if (this.requestMeta.followRedirects) {
            this.requestMeta.followRedirects = this.clientConfig.followRedirects;
        }
        if (20 == this.requestMeta.maxFollowRedirectTimes) {
            this.requestMeta.maxFollowRedirectTimes = this.clientConfig.maxFollowRedirectTimes;
        }
        if (!this.requestMeta.ignoreHttpErrors) {
            this.requestMeta.ignoreHttpErrors = this.clientConfig.ignoreHttpErrors;
        }
        if (3 == this.requestMeta.retryTimes) {
            this.requestMeta.retryTimes = this.clientConfig.retryTimes;
        }
    }
}

