/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickhttp.handler;

import cn.schoolwow.quickhttp.domain.LogLevel;
import cn.schoolwow.quickhttp.domain.MetaWrapper;
import cn.schoolwow.quickhttp.handler.AbstractHandler;
import cn.schoolwow.quickhttp.handler.Handler;
import cn.schoolwow.quickhttp.handler.RequestLogHandler;
import cn.schoolwow.quickhttp.response.EventSource;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventSourceHandler
extends AbstractHandler {
    private static Logger logger = LoggerFactory.getLogger(EventSourceHandler.class);

    public EventSourceHandler(MetaWrapper metaWrapper) {
        super(metaWrapper);
    }

    @Override
    public Handler handle() throws IOException {
        this.handleEventSource();
        return new RequestLogHandler(this.metaWrapper);
    }

    private void handleEventSource() throws IOException {
        if (null == this.responseMeta.contentType) {
            return;
        }
        if (!this.responseMeta.contentType.toLowerCase().contains("text/event-stream")) {
            return;
        }
        if (null == this.requestMeta.eventSourceConsumer) {
            return;
        }
        this.log(LogLevel.TRACE, "[\u5904\u7406EventSource]Content-Type:{}", this.responseMeta.contentType);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.responseMeta.inputStream, StandardCharsets.UTF_8));
        EventSource eventSource = null;
        String line = bufferedReader.readLine();
        StringBuilder builder = new StringBuilder();
        while (null != line) {
            if (line.equals("")) {
                this.requestMeta.eventSourceConsumer.accept(eventSource);
            } else {
                if (null == eventSource) {
                    eventSource = new EventSource();
                }
                if (line.startsWith("id:")) {
                    eventSource.id = Integer.parseInt(line.substring(line.indexOf(":") + 1));
                }
                if (line.startsWith("event:")) {
                    eventSource.event = line.substring(line.indexOf(":") + 1);
                }
                if (line.startsWith("retry:")) {
                    eventSource.retry = Integer.parseInt(line.substring(line.indexOf(":") + 1));
                }
                if (line.startsWith("data:")) {
                    eventSource.data = line.substring(line.indexOf(":") + 1);
                }
            }
            builder.append(line + "\r\n");
            line = bufferedReader.readLine();
        }
        this.responseMeta.body = builder.toString().getBytes(StandardCharsets.UTF_8);
    }
}

