/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickhttp.handler;

import cn.schoolwow.quickhttp.domain.ClientConfig;
import cn.schoolwow.quickhttp.domain.LogLevel;
import cn.schoolwow.quickhttp.domain.MetaWrapper;
import cn.schoolwow.quickhttp.domain.RequestMeta;
import cn.schoolwow.quickhttp.handler.AbstractHandler;
import cn.schoolwow.quickhttp.handler.Handler;
import cn.schoolwow.quickhttp.handler.ResponseHandler;
import cn.schoolwow.quickhttp.request.Request;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.net.ssl.HttpsURLConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestHandler
extends AbstractHandler {
    private static Logger logger = LoggerFactory.getLogger(RequestHandler.class);
    private static ThreadLocal<StringBuilder> builderThreadLocal = new ThreadLocal();
    private static final char[] mimeBoundaryChars = "-_1234567890abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
    private static final int boundaryLength = 32;

    public RequestHandler(MetaWrapper metaWrapper) {
        super(metaWrapper);
        StringBuilder builder = builderThreadLocal.get();
        if (null == builder) {
            builderThreadLocal.set(new StringBuilder());
        }
    }

    @Override
    public Handler handle() throws IOException {
        HttpURLConnection httpURLConnection;
        this.metaWrapper.responseMeta.httpURLConnection = httpURLConnection = this.createHttpUrlConnection(this.metaWrapper);
        return new ResponseHandler(this.metaWrapper);
    }

    /*
     * WARNING - void declaration
     */
    private HttpURLConnection createHttpUrlConnection(MetaWrapper metaWrapper) throws IOException {
        RequestMeta requestMeta = metaWrapper.requestMeta;
        ClientConfig clientConfig = metaWrapper.clientConfig;
        if (!requestMeta.parameterMap.isEmpty()) {
            StringBuilder parameterBuilder = builderThreadLocal.get();
            parameterBuilder.setLength(0);
            Set<Map.Entry<String, String>> entrySet = requestMeta.parameterMap.entrySet();
            for (Map.Entry<String, String> entry : entrySet) {
                void var8_9;
                String string = entry.getValue();
                if (null != string) {
                    String string2 = URLEncoder.encode(string, requestMeta.charset);
                }
                parameterBuilder.append(URLEncoder.encode(entry.getKey(), requestMeta.charset) + "=" + (String)var8_9 + "&");
            }
            parameterBuilder.deleteCharAt(parameterBuilder.length() - 1);
            if (requestMeta.url.toString().contains("?")) {
                parameterBuilder.insert(0, "&");
            } else {
                parameterBuilder.insert(0, "?");
            }
            requestMeta.url = new URL(requestMeta.url.toString() + parameterBuilder.toString());
        }
        URL u = requestMeta.url;
        HttpURLConnection httpURLConnection = (HttpURLConnection)(requestMeta.proxy == null ? u.openConnection() : u.openConnection(requestMeta.proxy));
        this.log(LogLevel.DEBUG, "[\u8bf7\u6c42\u884c]{} {},\u4ee3\u7406:{}", requestMeta.method.name(), u, requestMeta.proxy == null ? "\u65e0" : requestMeta.proxy.address());
        if (httpURLConnection instanceof HttpsURLConnection) {
            ((HttpsURLConnection)httpURLConnection).setSSLSocketFactory(clientConfig.sslSocketFactory);
            ((HttpsURLConnection)httpURLConnection).setHostnameVerifier(clientConfig.hostnameVerifier);
        }
        httpURLConnection.setRequestMethod(requestMeta.method.name());
        httpURLConnection.setConnectTimeout(requestMeta.connectTimeoutMillis);
        httpURLConnection.setReadTimeout(requestMeta.readTimeoutMillis);
        httpURLConnection.setInstanceFollowRedirects(false);
        Set<Map.Entry<String, List<String>>> entrySet = requestMeta.headerMap.entrySet();
        for (Map.Entry entry : entrySet) {
            for (String string : (List)entry.getValue()) {
                httpURLConnection.addRequestProperty((String)entry.getKey(), string);
            }
        }
        try {
            List<String> cookieList;
            Map<String, List<String>> cookieHeaderMap = clientConfig.cookieManager.get(requestMeta.url.toURI(), requestMeta.headerMap);
            if (cookieHeaderMap.containsKey("Cookie") && (cookieList = cookieHeaderMap.get("Cookie")).size() > 0) {
                StringBuilder stringBuilder = builderThreadLocal.get();
                stringBuilder.setLength(0);
                for (String string : cookieList) {
                    stringBuilder.append(" " + string + ";");
                }
                httpURLConnection.setRequestProperty("Cookie", stringBuilder.toString());
                this.log(LogLevel.TRACE, "[\u8bbe\u7f6eCookie\u5934\u90e8]{}", stringBuilder.toString());
            }
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        httpURLConnection.setDoInput(true);
        StringBuilder builder = builderThreadLocal.get();
        builder.setLength(0);
        if (null != requestMeta.contentType) {
            httpURLConnection.setRequestProperty("Content-Type", requestMeta.contentType);
        }
        if (!(!requestMeta.method.hasBody() || requestMeta.dataFileMap.isEmpty() && null == requestMeta.requestBody && requestMeta.dataMap.isEmpty())) {
            if (Request.ContentType.MULTIPART_FORMDATA.equals((Object)requestMeta.userContentType) || !requestMeta.dataFileMap.isEmpty()) {
                if (null == requestMeta.boundary) {
                    requestMeta.boundary = RequestHandler.mimeBoundary();
                }
                httpURLConnection.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + requestMeta.boundary);
                if (!requestMeta.dataFileMap.isEmpty()) {
                    builder.append("[MultipartFile]" + requestMeta.dataFileMap);
                }
                if (!requestMeta.dataMap.isEmpty()) {
                    builder.append("[Multipart]" + requestMeta.dataMap);
                }
            } else if (Request.ContentType.APPLICATION_JSON.equals((Object)requestMeta.userContentType) || requestMeta.requestBody != null && requestMeta.requestBody.length > 0) {
                if (null == requestMeta.contentType) {
                    httpURLConnection.setRequestProperty("Content-Type", (requestMeta.userContentType == null ? "application/json" : requestMeta.userContentType.value) + "; charset=" + requestMeta.charset);
                }
                builder.append(new String(requestMeta.requestBody, requestMeta.charset));
            } else if (Request.ContentType.APPLICATION_X_WWW_FORM_URLENCODED.equals((Object)requestMeta.userContentType) || !requestMeta.dataMap.isEmpty()) {
                httpURLConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded; charset=" + requestMeta.charset);
                if (!requestMeta.dataMap.isEmpty()) {
                    StringBuilder formBuilder = new StringBuilder();
                    Set<Map.Entry<String, String>> set = requestMeta.dataMap.entrySet();
                    for (Map.Entry entry : set) {
                        String value = (String)entry.getValue();
                        if (null != value) {
                            value = URLEncoder.encode(value, requestMeta.charset);
                        }
                        formBuilder.append(URLEncoder.encode((String)entry.getKey(), requestMeta.charset) + "=" + value + "&");
                    }
                    formBuilder.deleteCharAt(formBuilder.length() - 1);
                    requestMeta.requestBody = formBuilder.toString().getBytes(Charset.forName(requestMeta.charset));
                }
                builder.append("[Form]" + requestMeta.dataMap.toString());
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)baos, requestMeta.charset));
            if (Request.ContentType.MULTIPART_FORMDATA.equals((Object)requestMeta.userContentType) || !requestMeta.dataFileMap.isEmpty()) {
                if (!requestMeta.dataMap.isEmpty()) {
                    Set<Map.Entry<String, String>> entrySet3 = requestMeta.dataMap.entrySet();
                    for (Map.Entry<String, Object> entry : entrySet3) {
                        bufferedWriter.write("--" + requestMeta.boundary + "\r\n");
                        bufferedWriter.write("Content-Disposition: form-data; name=\"" + entry.getKey().replace("\"", "%22") + "\"\r\n");
                        bufferedWriter.write("\r\n");
                        bufferedWriter.write((String)entry.getValue());
                        bufferedWriter.write("\r\n");
                    }
                }
                Set<Map.Entry<String, Collection<Path>>> entrySet2 = requestMeta.dataFileMap.entrySet();
                for (Map.Entry<String, Object> entry : entrySet2) {
                    Collection pathCollection = (Collection)entry.getValue();
                    for (Path file : pathCollection) {
                        String name = entry.getKey().replace("\"", "%22");
                        bufferedWriter.write("--" + requestMeta.boundary + "\r\n");
                        bufferedWriter.write("Content-Disposition: form-data; name=\"" + name + "\"; filename=\"" + file.getFileName().toString().replace("\"", "%22") + "\"\r\n");
                        bufferedWriter.write("Content-Type: " + Files.probeContentType(file) + "\r\n");
                        bufferedWriter.write("\r\n");
                        bufferedWriter.flush();
                        baos.write(Files.readAllBytes(file));
                        baos.flush();
                        bufferedWriter.write("\r\n");
                    }
                }
                bufferedWriter.write("--" + requestMeta.boundary + "--\r\n");
            } else if (Request.ContentType.APPLICATION_JSON.equals((Object)requestMeta.userContentType) || requestMeta.requestBody != null && !requestMeta.requestBody.equals("")) {
                baos.write(requestMeta.requestBody);
            } else if ((Request.ContentType.APPLICATION_X_WWW_FORM_URLENCODED.equals((Object)requestMeta.userContentType) || !requestMeta.dataMap.isEmpty()) && null != requestMeta.requestBody) {
                baos.write(requestMeta.requestBody);
            }
            bufferedWriter.flush();
            bufferedWriter.close();
            switch (requestMeta.streamingMode) {
                case FixedLength: {
                    httpURLConnection.setFixedLengthStreamingMode(baos.size());
                    break;
                }
                case Chunked: {
                    httpURLConnection.setChunkedStreamingMode(0);
                }
            }
            httpURLConnection.setDoOutput(true);
            baos.writeTo(httpURLConnection.getOutputStream());
        }
        requestMeta.bodyLog = builder.toString();
        return httpURLConnection;
    }

    private static String mimeBoundary() {
        StringBuilder mime = new StringBuilder(32);
        Random rand = new Random();
        for (int i = 0; i < 32; ++i) {
            mime.append(mimeBoundaryChars[rand.nextInt(mimeBoundaryChars.length)]);
        }
        return mime.toString();
    }
}

