/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickhttp.handler;

import cn.schoolwow.quickhttp.domain.LogLevel;
import cn.schoolwow.quickhttp.domain.MetaWrapper;
import cn.schoolwow.quickhttp.handler.AbstractHandler;
import cn.schoolwow.quickhttp.handler.Handler;
import cn.schoolwow.quickhttp.handler.RedirectHandler;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestLogHandler
extends AbstractHandler {
    private static Logger logger = LoggerFactory.getLogger(RequestLogHandler.class);

    public RequestLogHandler(MetaWrapper metaWrapper) {
        super(metaWrapper);
    }

    @Override
    public Handler handle() throws IOException {
        if (!(this.requestMeta.ignoreHttpErrors || this.responseMeta.statusCode >= 200 && this.responseMeta.statusCode < 400)) {
            logger.warn("[\u8bf7\u6c42\u4e0e\u54cd\u5e94]{}\n{}", (Object)this.requestMeta.statusLine, (Object)this.getRequestAndResponseLog());
            throw new IOException("http\u72b6\u6001\u5f02\u5e38!\u72b6\u6001\u7801:" + this.responseMeta.statusCode + ",\u5730\u5740:" + this.requestMeta.url);
        }
        this.log(LogLevel.DEBUG, "[\u8bf7\u6c42\u4e0e\u54cd\u5e94]{}\n{}", this.requestMeta.statusLine, this.getRequestAndResponseLog());
        return new RedirectHandler(this.metaWrapper);
    }

    private String getRequestAndResponseLog() throws IOException {
        StringBuilder contentBuilder = new StringBuilder("\n====================================================================\n");
        contentBuilder.append(this.requestMeta.statusLine + "\n");
        Set<Map.Entry<String, List<String>>> requestHeaderSet = this.requestMeta.headerMap.entrySet();
        for (Map.Entry<String, List<String>> entry : requestHeaderSet) {
            for (String string : entry.getValue()) {
                contentBuilder.append(entry.getKey() + ": " + string + "\n");
            }
        }
        contentBuilder.append("\n" + this.requestMeta.bodyLog + "\n\n");
        contentBuilder.append(this.responseMeta.statusLine + "\n");
        Set<Map.Entry<String, List<String>>> responseHeaderSet = this.responseMeta.headerMap.entrySet();
        for (Map.Entry<String, List<String>> entry : responseHeaderSet) {
            for (String value : entry.getValue()) {
                contentBuilder.append(entry.getKey() + ": " + value + "\n");
            }
        }
        if (null != this.responseMeta.contentType) {
            if (this.responseMeta.contentType.contains("application/json") || this.responseMeta.contentType.contains("text/") || this.responseMeta.contentType.contains("charset")) {
                InputStream inputStream = this.response.bodyStream();
                if (null == inputStream || this.response.contentLength() < 0L) {
                    contentBuilder.append("\n[\u54cd\u5e94\u5185\u5bb9\u65e0\u6cd5\u83b7\u53d6]");
                } else if (this.response.contentLength() == 0L) {
                    contentBuilder.append("\n[\u54cd\u5e94\u5185\u5bb9\u4e3a\u7a7a]");
                } else {
                    int n = (int)Math.min(1024L, this.response.contentLength());
                    inputStream.mark(n);
                    byte[] byArray = new byte[n];
                    int n2 = inputStream.read(byArray, 0, byArray.length);
                    if (n2 > 0) {
                        contentBuilder.append("\n" + new String(byArray, 0, n2, Charset.forName(this.responseMeta.charset)) + "......");
                    } else {
                        contentBuilder.append("\n[\u54cd\u5e94\u5185\u5bb9\u4e3a\u7a7a]");
                    }
                    inputStream.reset();
                }
            }
        } else {
            contentBuilder.append("\n[" + this.response.contentLength() + "]");
        }
        contentBuilder.append("\n====================================================================\n");
        return contentBuilder.toString();
    }
}

