/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickhttp.response;

import cn.schoolwow.quickhttp.document.Document;
import cn.schoolwow.quickhttp.document.DocumentParser;
import cn.schoolwow.quickhttp.domain.ClientConfig;
import cn.schoolwow.quickhttp.domain.RequestMeta;
import cn.schoolwow.quickhttp.domain.ResponseMeta;
import cn.schoolwow.quickhttp.response.Response;
import cn.schoolwow.quickhttp.response.SpeedLimitInputStream;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpCookie;
import java.net.SocketTimeoutException;
import java.net.URLDecoder;
import java.nio.channels.Channels;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseImpl
implements Response {
    private Logger logger = LoggerFactory.getLogger(ResponseImpl.class);
    private RequestMeta requestMeta;
    private ResponseMeta responseMeta;
    private ClientConfig clientConfig;

    public ResponseImpl(RequestMeta requestMeta, ResponseMeta responseMeta, ClientConfig clientConfig) {
        this.requestMeta = requestMeta;
        this.responseMeta = responseMeta;
        this.clientConfig = clientConfig;
    }

    @Override
    public String url() {
        return this.responseMeta.httpURLConnection.getURL().toString();
    }

    @Override
    public int statusCode() {
        return this.responseMeta.statusCode;
    }

    @Override
    public String statusMessage() {
        return this.responseMeta.statusMessage;
    }

    @Override
    public String charset() {
        return this.responseMeta.charset;
    }

    @Override
    public String contentType() {
        return this.responseMeta.httpURLConnection.getContentType();
    }

    @Override
    public long contentLength() {
        return this.responseMeta.httpURLConnection.getContentLengthLong();
    }

    @Override
    public String filename() {
        String contentDisposition = this.responseMeta.httpURLConnection.getHeaderField("Content-Disposition");
        if (null == contentDisposition) {
            throw new IllegalArgumentException("\u8fd4\u56de\u5934\u90e8\u65e0\u6587\u4ef6\u540d\u79f0\u4fe1\u606f!");
        }
        String fileName = null;
        if (contentDisposition.indexOf("filename*=") > 0) {
            fileName = contentDisposition.substring(contentDisposition.indexOf("filename*=") + "filename*=".length());
            String charset = fileName.substring(0, fileName.indexOf("''")).replace("\"", "");
            fileName = fileName.substring(fileName.indexOf("''") + 2).replace("\"", "");
            fileName = new String(fileName.getBytes(StandardCharsets.UTF_8), Charset.forName(charset));
            try {
                fileName = URLDecoder.decode(fileName, charset);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        } else if (contentDisposition.indexOf("filename=") > 0) {
            fileName = contentDisposition.substring(contentDisposition.indexOf("filename=") + "filename=".length());
            fileName = fileName.replace("\"", "").trim();
        }
        return fileName;
    }

    @Override
    public boolean acceptRanges() {
        return this.hasHeader("Accept-Ranges", "bytes");
    }

    @Override
    public String contentEncoding() {
        List<String> values = this.header("Content-Encoding");
        return null == values ? null : values.get(0);
    }

    @Override
    public boolean hasHeader(String name) {
        return this.responseMeta.headerMap.containsKey(name);
    }

    @Override
    public boolean hasHeader(String name, String value) {
        return this.hasHeader(name) && this.responseMeta.headerMap.get(name).get(0).equals(value);
    }

    @Override
    public List<String> header(String name) {
        return this.responseMeta.headerMap.get(name);
    }

    @Override
    public Map<String, List<String>> headers() {
        return this.responseMeta.headerMap;
    }

    @Override
    public boolean hasCookie(String name) {
        return this.clientConfig.cookieOption.hasCookie(this.responseMeta.topHost, name);
    }

    @Override
    public boolean hasCookie(String name, String value) {
        HttpCookie httpCookie = this.clientConfig.cookieOption.getCookie(this.responseMeta.topHost, name);
        return null != httpCookie && httpCookie.getValue().equals(value);
    }

    @Override
    public Response maxDownloadSpeed(int maxDownloadSpeed) {
        if (null != this.responseMeta.inputStream) {
            SpeedLimitInputStream speedLimitInputStream = (SpeedLimitInputStream)this.responseMeta.inputStream;
            speedLimitInputStream.setMaxDownloadSpeed(maxDownloadSpeed);
        }
        return this;
    }

    @Override
    public String body() throws IOException {
        if (null == this.responseMeta.body) {
            this.bodyAsBytes();
        }
        return new String(this.responseMeta.body, Charset.forName(this.responseMeta.charset));
    }

    @Override
    public JSONObject bodyAsJSONObject() throws IOException {
        JSONObject object = JSON.parseObject(this.body());
        return object;
    }

    @Override
    public JSONArray bodyAsJSONArray() throws IOException {
        JSONArray array = JSON.parseArray(this.body());
        return array;
    }

    @Override
    public JSONObject jsonpAsJSONObject() throws IOException {
        String body = this.body();
        int startIndex = body.indexOf("(") + 1;
        int endIndex = body.lastIndexOf(")");
        return JSON.parseObject(body.substring(startIndex, endIndex));
    }

    @Override
    public JSONArray jsonpAsJSONArray() throws IOException {
        String body = this.body();
        int startIndex = body.indexOf("(") + 1;
        int endIndex = body.lastIndexOf(")");
        return JSON.parseArray(body.substring(startIndex, endIndex));
    }

    @Override
    public byte[] bodyAsBytes() throws IOException {
        if (null == this.responseMeta.inputStream) {
            throw new IOException("http\u8bf7\u6c42\u54cd\u5e94\u8f93\u5165\u6d41\u83b7\u53d6\u5931\u8d25!");
        }
        Path tempFilePath = Files.createTempFile("QuickHttp2.", ".response", new FileAttribute[0]);
        Files.copy(this.responseMeta.inputStream, tempFilePath, StandardCopyOption.REPLACE_EXISTING);
        this.responseMeta.body = Files.readAllBytes(tempFilePath);
        Files.deleteIfExists(tempFilePath);
        return this.responseMeta.body;
    }

    @Override
    public void bodyAsFile(String filePath) throws IOException {
        Path path = Paths.get(filePath, new String[0]);
        this.bodyAsFile(path);
    }

    @Override
    public void bodyAsFile(Path file) throws IOException {
        long fileSize;
        if (null == this.responseMeta.inputStream) {
            throw new IOException("\u5199\u5165\u6587\u4ef6\u5931\u8d25!\u8f93\u5165\u6d41\u4e3a\u7a7a!url:" + this.url());
        }
        if (!Files.exists(file.getParent(), new LinkOption[0])) {
            Files.createDirectories(file.getParent(), new FileAttribute[0]);
        }
        long l = fileSize = Files.exists(file, new LinkOption[0]) ? Files.size(file) : 0L;
        if (null != this.responseMeta.body) {
            if (Files.exists(file, new LinkOption[0])) {
                Files.write(file, this.responseMeta.body, StandardOpenOption.APPEND);
            } else {
                Files.write(file, this.responseMeta.body, StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);
            }
        } else {
            long contentLength = this.contentLength();
            for (int retryTimes = 1; retryTimes <= this.requestMeta.retryTimes; ++retryTimes) {
                try {
                    if (null != this.responseMeta.httpURLConnection.getContentEncoding() || contentLength == -1L) {
                        Files.deleteIfExists(file);
                        byte[] buffer = new byte[8192];
                        int length = 0;
                        FileOutputStream fos = new FileOutputStream(file.toFile());
                        while ((length = this.responseMeta.inputStream.read(buffer, 0, buffer.length)) >= 0) {
                            fos.write(buffer, 0, length);
                            if (!Thread.currentThread().isInterrupted()) continue;
                            this.logger.debug("[\u7ebf\u7a0b\u4e2d\u65ad]\u6587\u4ef6\u4e0b\u8f7d\u4efb\u52a1\u505c\u6b62!");
                            break;
                        }
                        fos.flush();
                        fos.close();
                        break;
                    }
                    ReadableByteChannel readableByteChannel = Channels.newChannel(this.responseMeta.inputStream);
                    EnumSet<StandardOpenOption> openOptions = null;
                    openOptions = Files.exists(file, new LinkOption[0]) ? EnumSet.of(StandardOpenOption.APPEND) : EnumSet.of(StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);
                    FileChannel fileChannel = FileChannel.open(file, openOptions, new FileAttribute[0]);
                    try {
                        fileChannel.transferFrom(readableByteChannel, Files.size(file), contentLength);
                    }
                    catch (ClosedByInterruptException e) {
                        this.logger.debug("[\u7ebf\u7a0b\u4e2d\u65ad]\u6587\u4ef6\u4e0b\u8f7d\u4efb\u52a1\u505c\u6b62!");
                        Thread.currentThread().interrupt();
                        break;
                    }
                    fileChannel.close();
                    break;
                }
                catch (SocketTimeoutException e) {
                    this.logger.warn("[\u4e0b\u8f7d\u8d85\u65f6]\u91cd\u8bd5{}/{},\u539f\u56e0:{},\u94fe\u63a5:{}", retryTimes, this.requestMeta.retryTimes, e.getMessage(), this.url());
                    continue;
                }
            }
        }
        if (Thread.currentThread().isInterrupted()) {
            return;
        }
        if (this.contentLength() > 0L) {
            long expectFileSize = fileSize + this.contentLength();
            if (!this.responseMeta.headerMap.containsKey("Content-Encoding") && (Files.notExists(file, new LinkOption[0]) || Files.size(file) != expectFileSize)) {
                this.logger.warn("[\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25]\u9884\u671f\u5927\u5c0f:{},\u5b9e\u9645\u5927\u5c0f:{},\u8def\u5f84:{}", expectFileSize, Files.size(file), file);
                return;
            }
        }
    }

    @Override
    public InputStream bodyStream() {
        return this.responseMeta.inputStream;
    }

    @Override
    public Document parse() throws IOException {
        if (this.responseMeta.document == null) {
            if (this.responseMeta.body == null) {
                this.body();
            }
            this.responseMeta.document = Document.parse(this.body());
        }
        return this.responseMeta.document;
    }

    @Override
    public DocumentParser parser() throws IOException {
        if (this.responseMeta.documentParser == null) {
            if (this.responseMeta.body == null) {
                this.body();
            }
            this.responseMeta.documentParser = DocumentParser.parse(this.body());
        }
        return this.responseMeta.documentParser;
    }

    @Override
    public void disconnect() {
        try {
            if (null != this.responseMeta.inputStream) {
                this.responseMeta.inputStream.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.responseMeta.httpURLConnection.disconnect();
    }

    @Override
    public String logFilePath() {
        return this.requestMeta.logFilePath;
    }

    @Override
    public ResponseMeta responseMeta() {
        return this.responseMeta;
    }
}

