/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickhttp.util;

import cn.schoolwow.quickhttp.domain.m3u8.M3u8Type;
import cn.schoolwow.quickhttp.domain.m3u8.MasterPlaylist;
import cn.schoolwow.quickhttp.domain.m3u8.MediaPlaylist;
import cn.schoolwow.quickhttp.domain.m3u8.tag.BYTERANGE;
import cn.schoolwow.quickhttp.domain.m3u8.tag.DATERANGE;
import cn.schoolwow.quickhttp.domain.m3u8.tag.EXTINF;
import cn.schoolwow.quickhttp.domain.m3u8.tag.IFRAMESTREAMINF;
import cn.schoolwow.quickhttp.domain.m3u8.tag.KEY;
import cn.schoolwow.quickhttp.domain.m3u8.tag.MAP;
import cn.schoolwow.quickhttp.domain.m3u8.tag.MEDIA;
import cn.schoolwow.quickhttp.domain.m3u8.tag.SEGMENT;
import cn.schoolwow.quickhttp.domain.m3u8.tag.SESSIONDATA;
import cn.schoolwow.quickhttp.domain.m3u8.tag.SESSIONKEY;
import cn.schoolwow.quickhttp.domain.m3u8.tag.START;
import cn.schoolwow.quickhttp.domain.m3u8.tag.STREAMINF;
import com.alibaba.fastjson.JSONObject;
import java.io.BufferedReader;
import java.io.StringReader;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Iterator;

public class M3u8Util {
    public static M3u8Type getM3u8Type(String content) {
        if (content.contains("#EXT-X-MEIDA") || content.contains("#EXT-X-STREAM-INF") || content.contains("#EXT-X-I-FRAME-STREAM-INF")) {
            return M3u8Type.MasterPlayList;
        }
        return M3u8Type.MediaPlayList;
    }

    public static MasterPlaylist getMasterPlaylist(String url, String content) throws Exception {
        MasterPlaylist masterPlaylist = new MasterPlaylist();
        BufferedReader br = new BufferedReader(new StringReader(content));
        Iterator iterator = br.lines().iterator();
        String relativePath = url.substring(0, url.lastIndexOf("/") + 1);
        while (iterator.hasNext()) {
            String line = (String)iterator.next();
            if (!line.startsWith("#EXT")) continue;
            String tag = line.contains(":") ? line.substring(0, line.indexOf(":")) : line;
            String attributes = line.contains(":") ? line.substring(line.indexOf(":") + 1) : "";
            switch (tag) {
                case "#EXT-X-VERSION": {
                    masterPlaylist.VERSION = attributes;
                    break;
                }
                case "#EXT-X-MEDIA": {
                    MEDIA media = M3u8Util.getInstance(MEDIA.class, attributes);
                    masterPlaylist.mediaList.add(media);
                    break;
                }
                case "#EXT-X-STREAM-INF": {
                    STREAMINF streaminf = M3u8Util.getInstance(STREAMINF.class, attributes);
                    streaminf.URI = (String)iterator.next();
                    if (!streaminf.URI.startsWith("http")) {
                        streaminf.URI = relativePath + streaminf.URI;
                    }
                    masterPlaylist.streaminfList.add(streaminf);
                    break;
                }
                case "#EXT-X-I-FRAME-STREAM-INF": {
                    IFRAMESTREAMINF iframestreaminf = M3u8Util.getInstance(IFRAMESTREAMINF.class, attributes);
                    masterPlaylist.iframestreaminfList.add(iframestreaminf);
                    break;
                }
                case "#EXT-X-SESSION-DATA": {
                    SESSIONDATA sessiondata = M3u8Util.getInstance(SESSIONDATA.class, attributes);
                    masterPlaylist.sessiondataList.add(sessiondata);
                    break;
                }
                case "#EXT-X-SESSION-KEY": {
                    SESSIONKEY sessionkey = M3u8Util.getInstance(SESSIONKEY.class, attributes);
                    masterPlaylist.sessionkeyList.add(sessionkey);
                    break;
                }
                case "#EXT-X-INDEPENDENT-SEGMENTS": {
                    masterPlaylist.INDEPENDENT_SEGMENTS = true;
                    break;
                }
                case "#EXT-X-START": {
                    START start;
                    masterPlaylist.start = start = M3u8Util.getInstance(START.class, attributes);
                    break;
                }
            }
        }
        return masterPlaylist;
    }

    public static MediaPlaylist getMediaPlaylist(String url, String content) throws Exception {
        MediaPlaylist mediaPlaylist = new MediaPlaylist();
        SEGMENT segment = new SEGMENT();
        BYTERANGE lastByteRange = null;
        KEY key = null;
        MAP map = null;
        BufferedReader br = new BufferedReader(new StringReader(content));
        Iterator iterator = br.lines().iterator();
        while (iterator.hasNext()) {
            String line = (String)iterator.next();
            if (line.startsWith("#EXT")) {
                String tag = line.contains(":") ? line.substring(0, line.indexOf(":")) : line;
                String attributes = line.contains(":") ? line.substring(line.indexOf(":") + 1) : "";
                switch (tag) {
                    case "#EXT-X-VERSION": {
                        mediaPlaylist.VERSION = attributes;
                        break;
                    }
                    case "#EXTINF": {
                        EXTINF extinf = new EXTINF();
                        extinf.duration = attributes.substring(0, attributes.indexOf(","));
                        extinf.title = attributes.substring(attributes.indexOf(",") + 1);
                        segment.extinf = extinf;
                        break;
                    }
                    case "#EXT-X-BYTERANGE": {
                        BYTERANGE byterange = new BYTERANGE();
                        if (attributes.contains("@")) {
                            byterange.n = Integer.parseInt(attributes.substring(0, attributes.indexOf("@")));
                            byterange.o = Integer.parseInt(attributes.substring(attributes.indexOf("@") + 1));
                        } else {
                            byterange.n = Integer.parseInt(attributes);
                            if (null != lastByteRange) {
                                byterange.o = lastByteRange.n + lastByteRange.o + 1;
                            }
                        }
                        lastByteRange = byterange;
                        segment.byterange = byterange;
                        break;
                    }
                    case "#EXT-X-DISCONTINUITY": {
                        segment.DISCONTINUITY = true;
                        break;
                    }
                    case "#EXT-X-KEY": {
                        key = M3u8Util.getInstance(KEY.class, attributes);
                        break;
                    }
                    case "#EXT-X-MAP": {
                        map = M3u8Util.getInstance(MAP.class, attributes);
                        break;
                    }
                    case "#EXT-X-PROGRAM-DATE-TIME": {
                        segment.PROGRAM_DATE_TIME = attributes;
                        break;
                    }
                    case "#EXT-X-DATERANGE": {
                        DATERANGE daterange;
                        segment.daterange = daterange = M3u8Util.getInstance(DATERANGE.class, attributes);
                        break;
                    }
                    case "SCTE35-CMD": 
                    case "SCTE35-OUT": 
                    case "SCTE35-IN": 
                    case "END-ON-NEXT": {
                        break;
                    }
                    case "#EXT-X-TARGETDURATION": {
                        mediaPlaylist.TARGETDURATION = Integer.parseInt(attributes);
                        break;
                    }
                    case "#EXT-X-MEDIA-SEQUENCE": {
                        mediaPlaylist.MEDIA_SEQUENCE = Integer.parseInt(attributes);
                        break;
                    }
                    case "#EXT-X-DISCONTINUITY-SEQUENCE": {
                        mediaPlaylist.DISCONTINUITY_SEQUENCE = Integer.parseInt(attributes);
                        break;
                    }
                    case "#EXT-X-ENDLIST": {
                        return mediaPlaylist;
                    }
                    case "#EXT-X-PLAYLIST-TYPE": {
                        mediaPlaylist.PLAYLIST_TYPE = attributes;
                        break;
                    }
                    case "#EXT-X-I-FRAMES-ONLY": {
                        mediaPlaylist.I_FRAMES_ONLY = true;
                        break;
                    }
                    case "#EXT-X-INDEPENDENT-SEGMENTS": {
                        mediaPlaylist.INDEPENDENT_SEGMENTS = true;
                        break;
                    }
                    case "#EXT-X-START": {
                        START start;
                        mediaPlaylist.start = start = M3u8Util.getInstance(START.class, attributes);
                        break;
                    }
                }
                continue;
            }
            if (line.startsWith("#") || line.equals("")) continue;
            segment.KEY = key;
            segment.MAP = map;
            segment.URI = line;
            mediaPlaylist.segmentList.add(segment);
            segment = new SEGMENT();
        }
        String relativePath = url.substring(0, url.lastIndexOf("/") + 1);
        for (SEGMENT segment2 : mediaPlaylist.segmentList) {
            if (segment2.URI.startsWith("http")) continue;
            segment2.URI = relativePath + segment2.URI;
        }
        return mediaPlaylist;
    }

    private static <T> T getInstance(Class<T> clazz, String attributes) throws Exception {
        JSONObject o = new JSONObject(true);
        int startIndex = 0;
        boolean inQuote = false;
        String key = null;
        String value = null;
        for (int currentIndex = 0; currentIndex < attributes.length(); ++currentIndex) {
            switch (attributes.charAt(currentIndex)) {
                case '=': {
                    key = attributes.substring(startIndex, currentIndex).trim();
                    startIndex = currentIndex + 1;
                    break;
                }
                case '\"': {
                    if (inQuote) {
                        inQuote = false;
                        value = attributes.substring(startIndex, currentIndex);
                    } else {
                        inQuote = true;
                        startIndex = currentIndex + 1;
                    }
                    if (currentIndex != attributes.length() - 1) break;
                    o.put(key, (Object)value);
                    break;
                }
                case ',': {
                    if (attributes.charAt(currentIndex - 1) != '\"') {
                        o.put(key, (Object)attributes.substring(startIndex, currentIndex));
                    } else if (!inQuote) {
                        o.put(key, (Object)value);
                    }
                    startIndex = currentIndex + 1;
                    break;
                }
            }
            if (currentIndex != attributes.length() - 1 || attributes.charAt(currentIndex) == '\"') continue;
            o.put(key, (Object)attributes.substring(startIndex));
        }
        Field[] fields = M3u8Util.getAllField(clazz);
        T instance = clazz.newInstance();
        for (Field field : fields) {
            String property = field.getName().replace("_", "-");
            if (!o.containsKey(property)) continue;
            field.set(instance, o.getString(property));
        }
        return instance;
    }

    private static Field[] getAllField(Class clazz) {
        ArrayList<AccessibleObject> fieldList = new ArrayList<AccessibleObject>();
        Class tempClass = clazz;
        while (null != tempClass) {
            AccessibleObject[] fields = tempClass.getDeclaredFields();
            Field.setAccessible(fields, true);
            for (AccessibleObject field : fields) {
                if (Modifier.isFinal(((Field)field).getModifiers()) || Modifier.isStatic(((Field)field).getModifiers())) continue;
                ((Field)field).setAccessible(true);
                fieldList.add(field);
            }
            if (null == (tempClass = tempClass.getSuperclass()) || !"java.lang.Object".equals(tempClass.getName())) continue;
            break;
        }
        return fieldList.toArray(new Field[0]);
    }
}

