/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickserver;

import cn.schoolwow.quickserver.domain.ServerConfigMeta;
import cn.schoolwow.quickserver.server.HttpServer;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuickServer {
    private Logger logger = LoggerFactory.getLogger(QuickServer.class);
    private ServerConfigMeta serverConfigMeta = new ServerConfigMeta();

    public static QuickServer newInstance() {
        JSON.DEFFAULT_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
        return new QuickServer();
    }

    public ServerConfigMeta serverConfigMeta() {
        return this.serverConfigMeta;
    }

    public QuickServer port(int port) {
        this.serverConfigMeta.port = port;
        return this;
    }

    public QuickServer register(Class ... componentClasses) {
        this.serverConfigMeta.applicationContext.register(componentClasses);
        return this;
    }

    public QuickServer scan(String ... basePackages) {
        this.serverConfigMeta.applicationContext.scan(basePackages);
        return this;
    }

    public QuickServer staticResourcePathPrefix(String staticResourcePathPrefix) {
        this.logger.info("[\u6307\u5b9a\u9759\u6001\u8def\u5f84\u524d\u7f00]{}", (Object)staticResourcePathPrefix);
        if (!staticResourcePathPrefix.startsWith("/")) {
            staticResourcePathPrefix = "/" + staticResourcePathPrefix;
        }
        this.serverConfigMeta.staticResourcePathPrefix = staticResourcePathPrefix;
        return this;
    }

    public QuickServer staticResourcePath(String staticResourcePath) {
        this.logger.info("[\u6307\u5b9a\u9759\u6001\u8def\u5f84]{}", (Object)staticResourcePath);
        this.serverConfigMeta.staticResourcePathMap.put(staticResourcePath, "");
        return this;
    }

    public QuickServer staticResourcePath(String staticResourcePath, String urlPrefix) {
        this.logger.info("[\u6307\u5b9a\u9759\u6001\u8def\u5f84]\u8def\u5f84:{},url\u524d\u7f00:{}", (Object)staticResourcePath, (Object)urlPrefix);
        this.serverConfigMeta.staticResourcePathMap.put(staticResourcePath, urlPrefix);
        return this;
    }

    public QuickServer keepAlive(boolean keepAlive) {
        this.serverConfigMeta.keepAlive = keepAlive;
        return this;
    }

    public QuickServer keepAliveTimeout(int keepAliveTimeout) {
        this.serverConfigMeta.keepAliveTimeout = keepAliveTimeout;
        return this;
    }

    public QuickServer maxLimitSpeed(int maxLimitSpeed) {
        this.serverConfigMeta.maxLimitSpeed = maxLimitSpeed;
        return this;
    }

    public QuickServer serializerFeature(SerializerFeature ... serializerFeatures) {
        this.serverConfigMeta.serializerFeatures = serializerFeatures;
        return this;
    }

    public QuickServer serializerDateFormat(String dateTimeFormat) {
        JSON.DEFFAULT_DATE_FORMAT = dateTimeFormat;
        return this;
    }

    public QuickServer logFilePath(String logFilePath) {
        this.serverConfigMeta.logFilePath = logFilePath;
        return this;
    }

    public void start() throws IOException {
        HttpServer httpServer = new HttpServer(this.serverConfigMeta);
        httpServer.start();
    }
}

