/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickserver.handler;

import cn.schoolwow.quickserver.controller.annotation.BasicAuth;
import cn.schoolwow.quickserver.controller.annotation.CookieValue;
import cn.schoolwow.quickserver.controller.annotation.CrossOrigin;
import cn.schoolwow.quickserver.controller.annotation.PathVariable;
import cn.schoolwow.quickserver.controller.annotation.RequestBody;
import cn.schoolwow.quickserver.controller.annotation.RequestHeader;
import cn.schoolwow.quickserver.controller.annotation.RequestParam;
import cn.schoolwow.quickserver.controller.annotation.RequestPart;
import cn.schoolwow.quickserver.controller.annotation.SessionValue;
import cn.schoolwow.quickserver.domain.Client;
import cn.schoolwow.quickserver.domain.MultipartFile;
import cn.schoolwow.quickserver.handler.Handler;
import cn.schoolwow.quickserver.handler.HttpResponseHandler;
import cn.schoolwow.quickserver.handler.StaticResourceHandler;
import cn.schoolwow.quickserver.request.HttpRequest;
import cn.schoolwow.quickserver.response.HttpResponse;
import cn.schoolwow.quickserver.response.HttpStatus;
import cn.schoolwow.quickserver.session.HttpSession;
import cn.schoolwow.quickserver.util.QuickServerUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.util.TypeUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.net.HttpCookie;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Base64;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControllerHandler
implements Handler {
    private Logger logger = LoggerFactory.getLogger(ControllerHandler.class);

    @Override
    public Handler handle(Client client) throws Exception {
        if (null == client.controllerMeta) {
            return new StaticResourceHandler();
        }
        if (!this.handleBasicAuth(client)) {
            return new HttpResponseHandler();
        }
        this.handleCrossOrigin(client);
        return this.invokeControllerMethod(client);
    }

    public boolean handleBasicAuth(Client client) {
        BasicAuth basicAuth = client.controllerMeta.method.getAnnotation(BasicAuth.class);
        if (null == basicAuth) {
            basicAuth = client.controllerMeta.method.getDeclaringClass().getAnnotation(BasicAuth.class);
        }
        if (null == basicAuth) {
            return true;
        }
        this.logger.debug("[BasicAuth]\u5730\u5740:{},\u7528\u6237\u540d:{},\u5bc6\u7801:{}", client.httpRequestMeta.uri, basicAuth.username(), basicAuth.password());
        if (client.httpRequestMeta.headers.containsKey("Authorization")) {
            String expectAuthorization;
            String authorization = client.httpRequestMeta.headers.get("Authorization").get(0);
            if ((authorization = authorization.substring(authorization.indexOf("Basic ") + 6)).equals(expectAuthorization = new String(Base64.getEncoder().encode((basicAuth.username() + ":" + basicAuth.password()).getBytes())))) {
                return true;
            }
        }
        client.httpResponseMeta.httpStatus(HttpStatus.UNAUTHORIZED);
        client.httpResponseMeta.headers.put("WWW-Authenticate", Arrays.asList("Basic realm=\"" + basicAuth.realm() + "\""));
        return false;
    }

    private void handleCrossOrigin(Client client) {
        CrossOrigin crossOriginAnnotation = client.controllerMeta.method.getDeclaredAnnotation(CrossOrigin.class);
        if (null == crossOriginAnnotation) {
            crossOriginAnnotation = client.controllerMeta.method.getDeclaringClass().getDeclaredAnnotation(CrossOrigin.class);
        }
        if (null == crossOriginAnnotation) {
            return;
        }
        this.logger.debug("[CrossOrigin]\u5904\u7406\u8de8\u57df\u8bf7\u6c42:{}", (Object)client.controllerMeta.method.getName());
        if (!client.httpRequestMeta.headers.containsKey("Origin")) {
            client.httpResponseMeta.httpStatus(HttpStatus.BAD_REQUEST);
            this.logger.warn("[CrossOrigin]\u670d\u52a1\u7aef\u4e3a\u8de8\u57df\u8bf7\u6c42,\u4f46\u5ba2\u6237\u7aef\u65e0Origin\u5934\u90e8!");
            return;
        }
        String origin = client.httpRequestMeta.headers.get("Origin").get(0);
        boolean allowOrigin = false;
        if (crossOriginAnnotation.origins().length == 0) {
            allowOrigin = true;
        } else {
            String[] crossOrigins;
            for (String crossOrigin : crossOrigins = crossOriginAnnotation.origins()) {
                if (!origin.equalsIgnoreCase(crossOrigin) && !"*".equalsIgnoreCase(crossOrigin)) continue;
                allowOrigin = true;
                break;
            }
        }
        if (!allowOrigin) {
            this.logger.warn("[CrossOrigin]origin\u5934\u90e8\u4e0d\u5339\u914d,\u8de8\u57df\u5931\u8d25!\u5ba2\u6237\u7aefOrigin\u5934\u90e8:{}", (Object)origin);
            return;
        }
        String accessControlRequestMethod = null;
        if (client.httpRequestMeta.headers.containsKey("Access-Control-Allow-Methods")) {
            accessControlRequestMethod = client.httpRequestMeta.headers.get("Access-Control-Allow-Methods").get(0);
        }
        if (null != accessControlRequestMethod && crossOriginAnnotation.methods().length > 0) {
            boolean allowMethod = false;
            for (String method : crossOriginAnnotation.methods()) {
                if (!accessControlRequestMethod.equalsIgnoreCase(method)) continue;
                allowMethod = true;
                break;
            }
            if (!allowMethod) {
                this.logger.warn("[CrossOrigin]\u8bf7\u6c42\u65b9\u6cd5\u4e0d\u5141\u8bb8!\u5ba2\u6237\u7aef\u5934\u90e8Access-Control-Allow-Methods:{}", (Object)accessControlRequestMethod);
                return;
            }
        }
        String accessControlRequestHeaders = null;
        if (client.httpRequestMeta.headers.containsKey("Access-Control-Allow-Headers")) {
            accessControlRequestHeaders = client.httpRequestMeta.headers.get("Access-Control-Allow-Headers").get(0);
        }
        if (null != accessControlRequestHeaders && crossOriginAnnotation.headers().length > 0) {
            String[] requestHeaders = accessControlRequestHeaders.split(",");
            for (String allowHeader : crossOriginAnnotation.headers()) {
                boolean exist = false;
                for (String requestHeader : requestHeaders) {
                    if (!"*".equals(allowHeader) && !requestHeader.equals(allowHeader)) continue;
                    exist = true;
                    break;
                }
                if (exist) continue;
                this.logger.warn("[CrossOrigin]\u8bf7\u6c42\u5934\u90e8\u4e0d\u5141\u8bb8!\u5ba2\u6237\u7aef\u5934\u90e8Access-Control-Allow-Headers:{}", (Object)accessControlRequestHeaders);
                return;
            }
        }
        if (!client.serverConfigMeta.crossOriginMap.containsKey(client.httpRequestMeta.uri)) {
            HashMap<String, List<String>> crossOriginMap = new HashMap<String, List<String>>();
            crossOriginMap.put("Access-Control-Allow-Origin", Arrays.asList(crossOriginAnnotation.origins().length == 0 ? "*" : origin));
            crossOriginMap.put("Access-Control-Max-Age", Arrays.asList(crossOriginAnnotation.maxAge() + ""));
            if (crossOriginAnnotation.allowCredentials()) {
                crossOriginMap.put("Access-Control-Allow-Credentials", Arrays.asList("true"));
            }
            if (crossOriginAnnotation.methods().length > 0) {
                StringBuffer stringBuffer = new StringBuffer();
                for (String method : crossOriginAnnotation.methods()) {
                    stringBuffer.append(method + ",");
                }
                stringBuffer.deleteCharAt(stringBuffer.length() - 1);
                crossOriginMap.put("Access-Control-Allow-Methods", Arrays.asList(stringBuffer.toString()));
            } else if (null != accessControlRequestMethod) {
                crossOriginMap.put("Access-Control-Allow-Methods", Arrays.asList(accessControlRequestMethod));
            }
            StringBuilder builder = new StringBuilder();
            if (crossOriginAnnotation.headers().length > 0) {
                for (String header : crossOriginAnnotation.headers()) {
                    builder.append(header + ",");
                }
                builder.deleteCharAt(builder.length() - 1);
                crossOriginMap.put("Access-Control-Allow-Headers", Arrays.asList(builder.toString()));
            } else if (null != accessControlRequestHeaders) {
                crossOriginMap.put("Access-Control-Allow-Headers", Arrays.asList(accessControlRequestHeaders));
            }
            if (crossOriginAnnotation.exposedHeaders().length > 0) {
                builder.setLength(0);
                for (String exposedHeader : crossOriginAnnotation.exposedHeaders()) {
                    builder.append(exposedHeader + ",");
                }
                builder.deleteCharAt(builder.length() - 1);
                crossOriginMap.put("Access-Control-Expose-Headers", Arrays.asList(builder.toString()));
            }
            client.serverConfigMeta.crossOriginMap.put(client.httpRequestMeta.uri, crossOriginMap);
        }
        client.httpResponseMeta.headers.putAll(client.serverConfigMeta.crossOriginMap.get(client.httpRequestMeta.uri));
    }

    public Handler invokeControllerMethod(Client client) throws Exception {
        Method method = client.controllerMeta.method;
        Object[] parameterArray = new Object[method.getParameterCount()];
        Parameter[] parameters = method.getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            Parameter parameter = parameters[i];
            Object parameterValue = this.getAutoWireType(client, parameter);
            if (null == parameterValue) {
                parameterValue = this.getPathVariable(client, parameter);
            }
            if (null == parameterValue) {
                parameterValue = this.getRequestParam(client, parameter);
            }
            if (null == parameterValue) {
                parameterValue = this.getRequestPart(client, parameter);
            }
            if (null == parameterValue) {
                parameterValue = this.getRequestBody(client, parameter);
            }
            if (null == parameterValue) {
                parameterValue = this.getSessionValue(client, parameter);
            }
            if (null == parameterValue) {
                parameterValue = this.getRequestHeader(client, parameter);
            }
            if (null == parameterValue) {
                parameterValue = this.getCookieValue(client, parameter);
            }
            if (null == parameterValue) {
                parameterValue = this.getCompositeParameter(client, parameter);
            }
            if (null == parameterValue) continue;
            parameterArray[i] = TypeUtils.cast(parameterValue, parameter.getType(), null);
        }
        Object result = null;
        try {
            result = method.invoke(client.controllerMeta.instance, parameterArray);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("\u8c03\u7528Controller\u65b9\u6cd5\u65f6\u8f6c\u6362\u65b9\u6cd5\u53c2\u6570\u5931\u8d25!\u8c03\u7528\u65b9\u6cd5:" + method.toString() + ",\u5931\u8d25\u539f\u56e0:" + e.getMessage());
        }
        if (null != client.serverConfigMeta.responseBodyAdvice && client.serverConfigMeta.responseBodyAdvice.support(method)) {
            result = client.serverConfigMeta.responseBodyAdvice.beforeBodyWrite(result, method, client.httpRequest, client.httpResponse, client.httpSession);
        }
        return this.handleResult(client, result);
    }

    private Object getAutoWireType(Client client, Parameter parameter) {
        if (parameter.getType().getName().equals(HttpRequest.class.getName())) {
            return client.httpRequest;
        }
        if (parameter.getType().getName().equals(HttpResponse.class.getName())) {
            return client.httpResponse;
        }
        if (parameter.getType().getName().equals(HttpSession.class.getName())) {
            return client.httpSession;
        }
        return null;
    }

    private Object getPathVariable(Client client, Parameter parameter) {
        PathVariable pathVariable = parameter.getAnnotation(PathVariable.class);
        if (null == pathVariable) {
            return null;
        }
        if (pathVariable.required() && !client.httpRequestMeta.pathVariable.containsKey(pathVariable.name())) {
            throw new IllegalArgumentException("\u8def\u5f84\u53d8\u91cf[" + pathVariable.name() + "]\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        return client.httpRequestMeta.pathVariable.get(pathVariable.name());
    }

    private Object getRequestParam(Client client, Parameter parameter) throws ParseException {
        RequestParam requestParam = parameter.getAnnotation(RequestParam.class);
        if (null == requestParam) {
            return null;
        }
        String requestParameter = client.httpRequestMeta.dataMap.get(requestParam.name());
        if (requestParam.required() && requestParameter == null) {
            throw new IllegalArgumentException("\u8868\u5355\u8bf7\u6c42\u53c2\u6570[" + requestParam.name() + "]\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (requestParameter == null) {
            requestParameter = requestParam.defaultValue();
        }
        String pattern = requestParam.pattern();
        if (requestParam.required() && !pattern.isEmpty() && requestParameter.isEmpty()) {
            throw new IllegalArgumentException("\u8868\u5355\u8bf7\u6c42\u53c2\u6570[" + requestParam.name() + "]\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (!pattern.isEmpty() && !requestParameter.isEmpty()) {
            return this.getDateParameterByType(pattern, parameter.getType(), requestParameter);
        }
        return requestParameter;
    }

    private Object getRequestPart(Client client, Parameter parameter) throws ParseException {
        RequestPart requestPart = parameter.getAnnotation(RequestPart.class);
        if (null == requestPart) {
            return null;
        }
        switch (parameter.getType().getName()) {
            case "cn.schoolwow.quickserver.domain.MultipartFile": {
                List<MultipartFile> multipartFileList = client.httpRequestMeta.fileParameterMap.get(requestPart.name());
                if (requestPart.required() && (multipartFileList == null || multipartFileList.isEmpty())) {
                    throw new IllegalArgumentException("\u8868\u5355\u8bf7\u6c42\u53c2\u6570[" + requestPart.name() + "]\u4e0d\u80fd\u4e3a\u7a7a!");
                }
                if (null == multipartFileList || multipartFileList.isEmpty()) {
                    return null;
                }
                return multipartFileList.get(0);
            }
            case "[Lcn.schoolwow.quickserver.domain.MultipartFile;": {
                List<MultipartFile> multipartFileList = client.httpRequestMeta.fileParameterMap.get(requestPart.name());
                if (requestPart.required() && (multipartFileList == null || multipartFileList.isEmpty())) {
                    throw new IllegalArgumentException("\u8868\u5355\u8bf7\u6c42\u53c2\u6570[" + requestPart.name() + "]\u4e0d\u80fd\u4e3a\u7a7a!");
                }
                if (null == multipartFileList || multipartFileList.isEmpty()) {
                    return new MultipartFile[0];
                }
                return multipartFileList;
            }
        }
        if (requestPart.required() && !client.httpRequestMeta.dataMap.containsKey(requestPart.name())) {
            throw new IllegalArgumentException("\u8868\u5355\u8bf7\u6c42\u53c2\u6570[" + requestPart.name() + "]\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        String requestParameter = client.httpRequestMeta.dataMap.get(requestPart.name());
        if (requestParameter == null) {
            requestParameter = requestPart.defaultValue();
        }
        String pattern = requestPart.pattern();
        if (requestPart.required() && !pattern.isEmpty() && requestParameter.isEmpty()) {
            throw new IllegalArgumentException("\u8868\u5355\u8bf7\u6c42\u53c2\u6570[" + requestPart.name() + "]\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (!pattern.isEmpty() && !requestParameter.isEmpty()) {
            return this.getDateParameterByType(pattern, parameter.getType(), requestParameter);
        }
        return requestParameter;
    }

    private Object getRequestBody(Client client, Parameter parameter) {
        RequestBody requestBody = parameter.getAnnotation(RequestBody.class);
        if (null == requestBody) {
            return null;
        }
        Class<?> type = parameter.getType();
        if (this.isPrimitiveType(type)) {
            return TypeUtils.cast((Object)client.httpRequestMeta.body, parameter.getType(), null);
        }
        if (type.getName().equals(String.class.getName())) {
            return client.httpRequestMeta.body;
        }
        if (client.httpRequestMeta.body.startsWith("{")) {
            if (parameter.getType().getName().equals(JSONObject.class.getName())) {
                return JSON.parseObject(client.httpRequestMeta.body);
            }
            return JSON.parseObject(client.httpRequestMeta.body).toJavaObject(parameter.getType());
        }
        if (client.httpRequestMeta.body.startsWith("[")) {
            if (parameter.getType().getName().equals(JSONArray.class.getName())) {
                return JSON.parseArray(client.httpRequestMeta.body);
            }
            return JSON.parseArray(client.httpRequestMeta.body).toJavaList(parameter.getType().getComponentType());
        }
        if (requestBody.required()) {
            throw new IllegalArgumentException("@RequestBody\u6ce8\u89e3\u65e0\u6cd5\u89e3\u6790\u8be5JSON\u53c2\u6570!\u53c2\u6570\u540d\u79f0:" + parameter.getName() + ",\u53c2\u6570\u503c:" + client.httpRequestMeta.body);
        }
        return null;
    }

    private Object getSessionValue(Client client, Parameter parameter) {
        SessionValue sessionValue = parameter.getAnnotation(SessionValue.class);
        if (null == sessionValue) {
            return null;
        }
        if (sessionValue.required() && !client.httpSessionMeta.attributes.containsKey(sessionValue.name())) {
            throw new IllegalArgumentException("SessionValue\u6ce8\u89e3[" + sessionValue.name() + "]\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        Object parameterValue = client.httpSessionMeta.attributes.get(sessionValue.name());
        this.logger.trace("[SessionValue]name:{},value:{},defaultValue:{}", sessionValue.name(), parameterValue, sessionValue.defaultValue());
        if (null == parameterValue) {
            parameterValue = sessionValue.defaultValue();
        }
        return parameterValue;
    }

    private Object getRequestHeader(Client client, Parameter parameter) {
        RequestHeader requestHeader = parameter.getAnnotation(RequestHeader.class);
        if (null == requestHeader) {
            return null;
        }
        List<String> requestHeaderValues = client.httpRequestMeta.headers.get(requestHeader.name());
        if (requestHeader.required() && null == requestHeaderValues) {
            throw new IllegalArgumentException("http\u5934\u90e8[" + requestHeader.name() + "]\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        String parameterValue = null == requestHeaderValues ? null : requestHeaderValues.get(0);
        this.logger.trace("[RequestHeader]name:{},value:{},defaultValue:{}", requestHeader.name(), parameterValue, requestHeader.defaultValue());
        if (null == parameterValue) {
            parameterValue = requestHeader.defaultValue();
        }
        return parameterValue;
    }

    private Object getCookieValue(Client client, Parameter parameter) {
        CookieValue cookieValue = parameter.getAnnotation(CookieValue.class);
        if (null == cookieValue) {
            return null;
        }
        HttpCookie httpCookie = client.httpRequestMeta.getHttpCookieByName(cookieValue.name());
        if (null == httpCookie) {
            throw new IllegalArgumentException("Cookie[" + cookieValue.name() + "]\u4e0d\u5b58\u5728!");
        }
        return httpCookie.getValue();
    }

    private Object getCompositeParameter(Client client, Parameter parameter) throws Exception {
        Class<?> parameterType = parameter.getType();
        if (this.isPrimitiveType(parameterType) || "java.lang.String".equals(parameterType.getName())) {
            return null;
        }
        Object instance = parameterType.newInstance();
        AccessibleObject[] fields = parameterType.getDeclaredFields();
        Field.setAccessible(fields, true);
        for (AccessibleObject field : fields) {
            if (!client.httpRequestMeta.dataMap.containsKey(((Field)field).getName())) continue;
            ((Field)field).set(instance, client.httpRequestMeta.dataMap.get(((Field)field).getName()));
        }
        return instance;
    }

    private Handler handleResult(Client client, Object result) throws IOException {
        if (null != result) {
            if (result instanceof byte[]) {
                if (null == client.httpResponseMeta.contentType) {
                    client.httpResponseMeta.contentType = "text/plain";
                }
                byte[] bytes = (byte[])result;
                client.httpResponseMeta.result = QuickServerUtil.byteArrayToHex(bytes);
                client.httpResponseMeta.contentLength = bytes.length;
                client.httpResponseMeta.bodyInputStream = new ByteArrayInputStream(bytes);
            } else {
                String resultString = result.toString();
                if (resultString.startsWith("redirect:")) {
                    client.httpResponseMeta.httpStatus(HttpStatus.FOUND);
                    client.httpResponseMeta.headers.put("Location", Arrays.asList(resultString.substring("redirect:".length())));
                } else if (this.isPrimitiveType(result.getClass()) || result instanceof String) {
                    if (null == client.httpResponseMeta.contentType) {
                        client.httpResponseMeta.contentType = "text/plain";
                    }
                    client.httpResponseMeta.result = String.valueOf(result);
                    byte[] bytes = client.httpResponseMeta.result.getBytes(client.httpResponseMeta.charset);
                    client.httpResponseMeta.contentLength = bytes.length;
                    client.httpResponseMeta.bodyInputStream = new ByteArrayInputStream(bytes);
                } else {
                    if (null == client.httpResponseMeta.contentType) {
                        client.httpResponseMeta.contentType = "application/json";
                    }
                    client.httpResponseMeta.result = JSON.toJSONString(result, client.serverConfigMeta.serializerFeatures);
                    byte[] bytes = client.httpResponseMeta.result.getBytes(client.httpResponseMeta.charset);
                    client.httpResponseMeta.contentLength = bytes.length;
                    client.httpResponseMeta.bodyInputStream = new ByteArrayInputStream(bytes);
                }
            }
        }
        return new HttpResponseHandler();
    }

    private Object getDateParameterByType(String pattern, Class parameterType, String requestParameter) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        java.util.Date date = sdf.parse(requestParameter);
        switch (parameterType.getName()) {
            case "java.util.Date": {
                return date;
            }
            case "java.sql.Date": {
                return new Date(date.getTime());
            }
            case "java.sql.Timestamp": {
                return new Timestamp(date.getTime());
            }
            case "java.util.Calendar": {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(date);
                return calendar;
            }
            case "java.time.LocalDate": {
                return LocalDate.parse(requestParameter, DateTimeFormatter.ofPattern(pattern));
            }
            case "java.time.LocalDateTime": {
                return LocalDateTime.parse(requestParameter, DateTimeFormatter.ofPattern(pattern));
            }
        }
        throw new IllegalArgumentException("\u4e0d\u652f\u6301\u8be5\u65e5\u671f\u7c7b\u578b,\u76ee\u524d\u652f\u6301\u7684\u7c7b\u578b\u4e3aDate,Calendar,LocalDate,LocalDateTime!\u5f53\u524d\u7c7b\u578b:" + parameterType.getName());
    }

    private boolean isPrimitiveType(Class<?> clazz) {
        try {
            if (clazz.isPrimitive()) {
                return true;
            }
            return ((Class)clazz.getField("TYPE").get(null)).isPrimitive();
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            return false;
        }
    }
}

