/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickserver.handler;

import cn.schoolwow.quickserver.controller.RequestMethod;
import cn.schoolwow.quickserver.domain.Client;
import cn.schoolwow.quickserver.domain.ControllerMeta;
import cn.schoolwow.quickserver.handler.Handler;
import cn.schoolwow.quickserver.handler.HttpResponseHandler;
import cn.schoolwow.quickserver.handler.LogFilePathHandler;
import cn.schoolwow.quickserver.interceptor.HandlerInterceptor;
import cn.schoolwow.quickserver.interceptor.Interceptor;
import cn.schoolwow.quickserver.util.AntPathMatcherUtil;
import cn.schoolwow.quickserver.util.ExceptionHandlerUtil;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DispatcherHandler
implements Handler {
    private Logger logger = LoggerFactory.getLogger(DispatcherHandler.class);

    @Override
    public Handler handle(Client client) throws Exception {
        this.getControllerMeta(client);
        Collection<HandlerInterceptor> interceptorList = client.serverConfigMeta.applicationContext.getBeansOfType(HandlerInterceptor.class).values();
        for (HandlerInterceptor handlerInterceptor : interceptorList) {
            if (!this.matchInterceptor(client, handlerInterceptor) || handlerInterceptor.preHandle(client.httpRequest, client.httpResponse, client.httpSession)) continue;
            return new HttpResponseHandler();
        }
        Handler handler = new LogFilePathHandler();
        while (null != handler && !(handler instanceof HttpResponseHandler)) {
            try {
                handler = handler.handle(client);
            }
            catch (Exception e) {
                ExceptionHandlerUtil.handleExceptionHandler(client, e);
                handler = new HttpResponseHandler();
            }
        }
        for (HandlerInterceptor handlerInterceptor : interceptorList) {
            if (!this.matchInterceptor(client, handlerInterceptor)) continue;
            handlerInterceptor.postHandle(client.httpRequest, client.httpResponse, client.httpSession);
        }
        for (HandlerInterceptor handlerInterceptor : interceptorList) {
            if (!this.matchInterceptor(client, handlerInterceptor)) continue;
            handlerInterceptor.beforeResponse(client.httpRequest, client.httpResponse, client.httpSession);
        }
        return handler;
    }

    private void getControllerMeta(Client client) {
        for (ControllerMeta controllerMeta : client.serverConfigMeta.controllerMetaList) {
            String mappingUrl;
            int urlPos = 0;
            int mappingPos = 0;
            int lastUrlPos = 0;
            int lastMappingPos = 0;
            String requestPath = client.httpRequestMeta.uri.getPath();
            String antRequestUrl = mappingUrl = controllerMeta.mappingUrl;
            while (urlPos < requestPath.length() && mappingPos < mappingUrl.length()) {
                if (mappingUrl.charAt(mappingPos) == '{') {
                    lastUrlPos = urlPos;
                    lastMappingPos = mappingPos + 1;
                    while (mappingPos < mappingUrl.length() && mappingUrl.charAt(mappingPos) != '}') {
                        ++mappingPos;
                    }
                    if (mappingPos >= mappingUrl.length()) continue;
                    String name = mappingUrl.substring(lastMappingPos, mappingPos);
                    antRequestUrl = antRequestUrl.replace("{" + name + "}", "*");
                    String value = null;
                    if (mappingPos + 1 < mappingUrl.length()) {
                        while (urlPos < requestPath.length() && requestPath.charAt(urlPos) != mappingUrl.charAt(mappingPos + 1)) {
                            ++urlPos;
                        }
                        if (urlPos < requestPath.length()) {
                            value = requestPath.substring(lastUrlPos, urlPos);
                        }
                    } else {
                        value = requestPath.substring(lastUrlPos);
                    }
                    client.httpRequestMeta.pathVariable.put(name, value);
                    continue;
                }
                if (requestPath.charAt(urlPos) == mappingUrl.charAt(mappingPos)) {
                    ++urlPos;
                    ++mappingPos;
                    continue;
                }
                ++mappingPos;
            }
            if ((!mappingUrl.contains("{") || !AntPathMatcherUtil.match(requestPath, antRequestUrl)) && !requestPath.equals(mappingUrl)) continue;
            for (RequestMethod requestMethod : controllerMeta.requestMethodList) {
                if (!requestMethod.name().equalsIgnoreCase(client.httpRequestMeta.method)) continue;
                this.logger.trace("[\u5339\u914dController]\u8def\u5f84:{},\u5904\u7406\u65b9\u6cd5:{}", (Object)client.httpRequestMeta.uri.getPath(), (Object)controllerMeta.method.toString());
                client.controllerMeta = controllerMeta;
                return;
            }
        }
        this.logger.trace("[\u672a\u5339\u914dController]\u8def\u5f84:{}", (Object)client.httpRequestMeta.uri.getPath());
    }

    private boolean matchInterceptor(Client client, HandlerInterceptor handlerInterceptor) {
        String uri = client.httpRequestMeta.uri.getPath();
        Interceptor interceptor = handlerInterceptor.getClass().getDeclaredAnnotation(Interceptor.class);
        if (null == interceptor) {
            return false;
        }
        for (String excludePattern : interceptor.excludePatterns()) {
            if (!AntPathMatcherUtil.match(uri, excludePattern)) continue;
            return false;
        }
        if (interceptor.excludeStaticResource() && null == client.controllerMeta) {
            return false;
        }
        for (String pattern : interceptor.patterns()) {
            if (!AntPathMatcherUtil.match(uri, pattern)) continue;
            return true;
        }
        return false;
    }
}

