/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickserver.handler;

import cn.schoolwow.quickserver.domain.Client;
import cn.schoolwow.quickserver.handler.DispatcherHandler;
import cn.schoolwow.quickserver.handler.Handler;
import java.io.IOException;
import java.net.HttpCookie;
import java.util.Date;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpSessionHandler
implements Handler {
    public static final String SESSION = "quickServerSession";
    private Logger logger = LoggerFactory.getLogger(HttpSessionHandler.class);

    @Override
    public Handler handle(Client client) throws IOException {
        HttpCookie sessionCookie = client.httpRequestMeta.cookieList.stream().filter(httpCookie -> httpCookie.getName().equalsIgnoreCase(SESSION)).findFirst().orElse(null);
        if (null != sessionCookie) {
            this.logger.trace("[\u83b7\u53d6\u4f1a\u8bddid]{}={}", (Object)sessionCookie.getName(), (Object)sessionCookie.getValue());
        }
        if (null == sessionCookie || !client.serverConfigMeta.sessionMap.containsKey(sessionCookie.getValue())) {
            client.httpSessionMeta.id = UUID.randomUUID().toString();
            client.httpSessionMeta.createdTime = System.currentTimeMillis();
            client.serverConfigMeta.sessionMap.put(client.httpSessionMeta.id, client.httpSessionMeta);
            sessionCookie = new HttpCookie(SESSION, client.httpSessionMeta.id);
            sessionCookie.setPath("/");
            sessionCookie.setHttpOnly(true);
            sessionCookie.setSecure(false);
            sessionCookie.setMaxAge(client.serverConfigMeta.sessionTimeout);
            sessionCookie.setVersion(0);
            client.httpResponse.addCookie(sessionCookie);
            this.logger.trace("[\u521b\u5efa\u4f1a\u8bdd]\u4f1a\u8bddid:{}", (Object)client.httpSessionMeta.id);
        } else {
            client.httpSessionMeta = client.serverConfigMeta.sessionMap.get(sessionCookie.getValue());
            client.httpSessionMeta.lastAccessedTime = System.currentTimeMillis();
            this.logger.trace("[\u4f1a\u8bdd\u5df2\u5b58\u5728]\u4e0a\u6b21\u8bbf\u95ee:{},\u4f1a\u8bdd\u5c5e\u6027:{}", (Object)new Date(client.httpSessionMeta.lastAccessedTime), (Object)client.httpSessionMeta.attributes);
        }
        return new DispatcherHandler();
    }
}

