/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickserver.handler;

import cn.schoolwow.quickserver.domain.Client;
import cn.schoolwow.quickserver.handler.ControllerHandler;
import cn.schoolwow.quickserver.handler.Handler;
import cn.schoolwow.quickserver.response.EventSource;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.SocketException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogFilePathHandler
implements Handler {
    private Logger logger = LoggerFactory.getLogger(LogFilePathHandler.class);

    @Override
    public Handler handle(Client client) throws Exception {
        if ("/quickServerLog".equalsIgnoreCase(client.httpRequestMeta.uri.getPath())) {
            this.doLog(client);
            return null;
        }
        return new ControllerHandler();
    }

    private void doLog(Client client) throws IOException {
        if (null == client.serverConfigMeta.logFilePath) {
            client.httpResponse.eventSource(new EventSource(0L, "close", "\u5e94\u7528\u672a\u8bbe\u7f6e\u65e5\u5fd7\u8def\u5f84!"));
            return;
        }
        StringBuilder logFilePathBuilder = new StringBuilder(client.serverConfigMeta.logFilePath);
        while (logFilePathBuilder.indexOf("{") >= 0) {
            int startIndex = logFilePathBuilder.indexOf("{");
            int endIndex = logFilePathBuilder.indexOf("}");
            String datePattern = logFilePathBuilder.substring(startIndex + 1, endIndex);
            String dateValue = LocalDateTime.now().format(DateTimeFormatter.ofPattern(datePattern));
            logFilePathBuilder.replace(startIndex, endIndex + 1, dateValue);
        }
        File file = new File(logFilePathBuilder.toString());
        long lastReadPointer = file.length();
        RandomAccessFile raf = null;
        byte[] buffer = new byte[512];
        if (file.exists()) {
            raf = new RandomAccessFile(file, "r");
            raf.seek(Math.max(0L, file.length() - (long)buffer.length));
            int length = raf.read(buffer, 0, (int)Math.min((long)buffer.length, file.length()));
            String data = new String(buffer, 0, length).replaceAll("\n", "<br/>");
            client.httpResponse.eventSource(new EventSource(0L, "log", data));
        }
        int index = 1;
        while (true) {
            if (null == raf && file.exists()) {
                raf = new RandomAccessFile(file, "r");
            }
            if (null != raf && file.length() > lastReadPointer) {
                raf.seek(lastReadPointer);
                int length = 0;
                while ((length = raf.read(buffer, 0, buffer.length)) != -1) {
                    String data = new String(buffer, 0, length).replaceAll("\n", "<br/>");
                    client.httpResponse.eventSource(new EventSource(index++, "log", data));
                }
                lastReadPointer = file.length();
            }
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            try {
                client.socket.sendUrgentData(0);
            }
            catch (SocketException e) {
                this.logger.info("[\u65e5\u5fd7\u7ebf\u7a0b\u9000\u51fa]\u5ba2\u6237\u7aef\u5173\u95ed\u8fde\u63a5!");
                return;
            }
        }
    }
}

