/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickserver.session;

import cn.schoolwow.quickserver.domain.Client;
import cn.schoolwow.quickserver.session.HttpSession;
import java.net.HttpCookie;
import java.util.Date;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpSessionImpl
implements HttpSession {
    private Logger logger = LoggerFactory.getLogger(HttpSessionImpl.class);
    private Client client;

    public HttpSessionImpl(Client client) {
        this.client = client;
    }

    @Override
    public String getId() {
        return this.client.httpSessionMeta.id;
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.client.httpSessionMeta.attributes;
    }

    @Override
    public Date getCreatedTime() {
        return new Date(this.client.httpSessionMeta.createdTime);
    }

    @Override
    public Date getLastAccessedTime() {
        return new Date(this.client.httpSessionMeta.lastAccessedTime);
    }

    @Override
    public void invalidate() {
        this.logger.debug("[\u9500\u6bc1\u4f1a\u8bdd]\u4f1a\u8bddid:{}", (Object)this.client.httpSessionMeta.id);
        this.client.serverConfigMeta.sessionMap.remove(this.client.httpSessionMeta.id);
        HttpCookie httpCookie = new HttpCookie("quickServerSession", this.client.httpSessionMeta.id);
        httpCookie.setMaxAge(0L);
        this.client.httpResponse.addCookie(httpCookie);
    }
}

