ams.resource("forwardServerResource", {
    "key": "id",
    "api": {
        "prefix": "/forwardServer/",
        "list": "list",
        "create": "create",
        "update": "update",
        "delete": "delete"
    },
    "fields": {
        "id": {
            "type": "text",
            "label": "id",
            "hidden": true
        },
        "name": {
            "type": "text",
            "label": "名称",
            "rules": [{
                "required": true,
                "message": "请输入名称",
                "trigger": "blur"
            }],
        },
        "ipv4": {
            "type": "text",
            "label": "转发IP",
            "rules": [{
                "required": true,
                "message": "请输入服务器IPv4",
                "trigger": "blur"
            }],
        },
        "port": {
            "type": "text",
            "label": "转发端口",
            "default": "53",
            "rules": [{
                "required": true,
                "message": "请输入服务器端口",
                "trigger": "blur"
            }],
            "props":{
                "width": "50"
            }
        },
        "hosts": {
            "type": "text",
            "label": "匹配主机域名",
            "info": "匹配该主机域名时才转发到该服务器.若为空则表示无限制.多个主机域名用逗号隔开"
        },
        "priority": {
            "type": "inputnumber",
            "label": "优先级",
            "info": "优先级,越小越优先",
            "rules": [{
                "required": true,
                "message": "请输入优先级",
                "trigger": "blur"
            }],
            "props":{
                "width": "70"
            }
        },
        "consumeTime": {
            "type": "inputnumber",
            "label": "响应速度(毫秒)",
            "ctx": "view",
            "info": "-1表示无法连通"
        },
        "enable":{
            "type": "switch",
            "label": "是否启用",
            "ctx": "edit",
        },
        "createdTime":{
            "type": "text",
            "label": "创建时间",
            "hidden": true
        },
        "updatedTime":{
            "type": "text",
            "label": "更新时间",
            "hidden": true
        }
    },
});

ams.block("forwardServerList",{
    "resource": "forwardServerResource",
    "type": "list",
    "ctx": "view",
    "events": {
        "init": "@list"
    },
    "props": {
        "empty-text": "当前暂无DNS转发服务器记录",
    },
    "options": {
        "multipleSelect": true,
        "drag": true
    },
    "on": {
        "drag-start": function(t) {},
        "drag-end": function(t) {
            let ids = [];
            for(let i=0;i<this.data.list.length;i++){
                ids.push(this.data.list[i].id);
            }
            return ams.request({
                "method": "get",
                "url": "/forwardServer/updatePriority",
                "params": {
                    "ids": ids.join()
                },
                "contentType": "form"
            }).then(function(){
                ams.callAction("forwardServerList.list:1")
            });
        }
    },
    "operations": {
        "addRecord": {
            "type": "button",
            "label": "新增DNS转发服务器记录",
            "props": {
                "type": "primary",
                "icon": "el-icon-circle-plus"
            },
            "slot": "rightTop",
            "event": "addItemDialogAction @showAction list:1"
        },
        "getConsumeTime": {
            "type": "button",
            "label": "测速",
            "props": {
                "type": "primary",
            },
            "event": "getConsumeTime list:1"
        },
        "updateRecord": {
            "type": "button",
            "label": "编辑",
            "props": {
                "type": "warning",
                "icon": "el-icon-edit",
            },
            "event": "editItemDialogAction @showAction list:1"
        },
        "deleteRecord": {
            "type": "button",
            "label": "删除",
            "props": {
                "type": "danger",
                "icon": "el-icon-delete"
            },
            "event": "confirm:确认删除该记录吗? delete list:1"
        },
        "multiDeleteRecord": {
            "slot": "multipleSelect",
            "type": "button",
            "label": "批量删除",
            "props": {
                "type": "danger",
                "icon": "el-icon-delete"
            },
            "event": "confirm:确认批量删除吗? delete list:1"
        },
        "multiGetConsumeTime": {
            "slot": "multipleSelect",
            "type": "button",
            "label": "批量测速",
            "props": {
                "type": "primary",
            },
            "event": "confirm:确认批量测速吗? getConsumeTime list:1"
        },
        "resetForwardServer": {
            "type": "button",
            "label": "重置列表",
            "props": {
                "type": "warning"
            },
            "slot": "rightTop",
            "event": "confirm:确认重置转发服务器列表吗? resetForwardServer list:1"
        },
    },
    "actions":{
        setPriority(){
            this.data.priority = ams.$prevReturn.data.data.total+1;
        },
        addItemDialogAction(){
            return this.callAction("@addItemDialog",{
                "resource": "forwardServerResource",
                "operation":{
                    "formProps":{
                        "label-width": "200px",
                    },
                    "fields":{
                        "consumeTime": {
                            "type": "text",
                            "label": "响应速度(毫秒)",
                            "hidden": true
                        },
                    }
                },
            });
        },
        editItemDialogAction(){
            return this.callAction("@editItemDialog",{
                "resource": "forwardServerResource",
                "operation":{
                    "formProps":{
                        "label-width": "200px"
                    },
                    "fields":{
                        "consumeTime": {
                            "type": "text",
                            "label": "响应速度(毫秒)",
                            "hidden": true
                        },
                    }
                }
            });
        },
        resetForwardServer(){
            return ams.request({
                "method": "get",
                "url": "/forwardServer/resetForwardServer",
                "withCredentials": true
            });
        },
        fieldChange({field,name,value,path}){
            if(name=="enable"){
                let index = parseInt(path.substring(path.indexOf("[")+1,path.indexOf("]")));
                let row = this.data.list[index];
                row[name] = value;
                return ams.request({
                    "method": "post",
                    "url": "/forwardServer/update",
                    "data": row,
                    "contentType": "json"
                }).then(function(){
                    ams.callAction("forwardServerList.list:1");
                })
            }
        },
        getConsumeTime(t){
            this.showLoading();
            if(Array.isArray(t.$prevReturn)){
                let ids = [];
                let array = t.$prevReturn;
                for(let i=0;i<array.length;i++){
                    ids.push(array[i].id);
                }
                return ams.request({
                    "method": "get",
                    "url": "/forwardServer/getConsumeTime",
                    "params": {
                        "ids": ids.join(",")
                    },
                    "contentType": "form"
                }).finally(()=>{
                    this.hideLoading();
                });
            }else{
                return ams.request({
                    "method": "get",
                    "url": "/forwardServer/getConsumeTime",
                    "params": {
                        "ids": t.$prevReturn.id
                    },
                    "contentType": "form"
                }).finally(()=>{
                    this.hideLoading();
                });
            }
        }
    }
});