ams.resource("recordResource", {
    "key": "id",
    "api": {
        "prefix": "/record/",
        "list": "list",
        "create": "create",
        "update": "update",
        "delete": "delete"
    },
    "fields": {
        "type": {
            "type": "select",
            "label": "DNS类型",
            "props": {
                "placeholder": "请选择",
                "multiple": false,
                "options": {
                    "A": "A记录",
                    "NS": "NS记录",
                    "CNAME": "CNAME记录",
                    "SOA": "SOA记录",
                    "PTR": "PTR记录",
                    "MX": "MX记录",
                    "TXT": "TXT记录",
                    "AAAA": "AAAA记录",
                    "": "全部",
                }
            },
            "rules": [{
                "required": true,
                "message": "请选择DNS类型",
                "trigger": "blur"
            }],
            "info": "设置DNS记录类型<br/>CNAME:域名<br/>NS:名称服务器<br/>PTR:反向解析<br/>TXT:文本记录<br/>A:ipv4地址<br/>AAAA:ipv6地址"
        },
        "host": {
            "type": "text",
            "label": "主机域名",
            "props": {
                "placeholder": "请输入主机域名",
            },
            "rules": [{
                "required": true,
                "message": "请输入主机域名",
                "trigger": "blur"
            }],
            "info": "主机域名,即域名前缀,常用的有www,@,*,mail等等,对于PTR记录则为IP地址"
        },
        "value": {
            "type": "text",
            "label": "记录值",
            "props": {
                "placeholder": "请输入记录值,多个记录值可用英文逗号隔开,保存时会自动拆分成多条(仅支持新增记录)",
            },
            "rules": [{
                "required": true,
                "message": "请输入记录值",
                "trigger": "blur"
            }],
            "info": "多个记录值可用英文逗号隔开,保存时会自动拆分成多条(仅支持新增记录)"
        },
        "ttl": {
            "type": "inputnumber",
            "label": "缓存时间(秒)",
            "props": {
                "placeholder": "请输入缓存时间(秒)",
            },
            "rules": [{
                "required": true,
                "message": "请输入缓存时间(秒)",
                "trigger": "blur"
            }],
            "default": "600"
        },
        "ipSource": {
            "type": "select",
            "label": "请求IP来源",
            "default": 0,
            "props":{
                "multiple": false,
                "options": [
                    {
                        "label": "全部",
                        "value": 0,
                    },
                    {
                        "label": "内网",
                        "value": 1,
                    },
                    {
                        "label": "外网",
                        "value": 2,
                    },
                ]
            },
            "rules": [{
                "required": true,
                "message": "请选择IP来源",
                "trigger": "blur"
            }],
            "info": "该条记录匹配的IP来源!<br/>" +
                "全部:所有IP<br/>" +
                "内网:内网IP<br/>&nbsp;&nbsp;10.0.0.0 到 10.255.255.255<br/>&nbsp;&nbsp;172.16.0.0 到172.31.255.255<br/>&nbsp;&nbsp;192.168.0.0 到192.168.255.255<br/>" +
                "外网:不在内网的IP",
        },
        "enable":{
            "type": "switch",
            "label": "是否启用",
            "ctx": "edit"
        },
        "createdTime":{
            "type": "text",
            "label": "创建时间",
            "hidden": true
        },
        "updatedTime":{
            "type": "text",
            "label": "更新时间",
            "hidden": true
        }
    },
    "sorts": {
        "createdTime": true
    },
});

let recordDialogConfig = {
    "resource": "recordResource",
    "operation":{
        "formProps":{
            "label-width": "200px",
        },
        "fields":{
            "type":{
                "default": "A",
                "on":{
                    change(val){
                        switch (val) {
                            case "MX":{
                                let value = {
                                    "preference": 10,
                                    "exchange": "mail.example.com"
                                };
                                this.data.value = JSON.stringify(value);
                            }break;
                            case "SOA":{
                                let value = {
                                    "mname": "dns9.hichina.com",
                                    "rname": "hostmaster.hichina.com",
                                    "serial": 2022052002,
                                    "refresh": 3600,
                                    "retry": 1200,
                                    "expire": 86400
                                };
                                this.data.value = JSON.stringify(value);
                            }break;
                        }
                    }
                }
            },
            "consumeTime": {
                "type": "text",
                "label": "响应速度(毫秒)",
                "hidden": true
            },
        },
    },
};

ams.block("recordList",{
    "resource": "recordResource",
    "type": "list",
    "ctx": "view",
    "events": {
        "init": "@list"
    },
    "props": {
        "empty-text": "当前暂无DNS记录",
        "label-width": "200px"
    },
    "options": {
        "multipleSelect": true
    },
    "operations": {
        "type": {
            "slot": "searchs",
            "type": "field",
            "label": "类型",
        },
        "host": {
            "slot": "searchs",
            "type": "field",
            "label": "主机域名",
        },
        "value": {
            "slot": "searchs",
            "type": "field",
            "label": "记录值",
        },
        "search": {
            "slot": "searchs",
            "type": "button",
            "label": "搜索",
            "props": {
                "type": "primary",
                "icon": "el-icon-search"
            },
            "event": "list:1"
        },
        "addRecord": {
            "type": "button",
            "label": "新增记录",
            "props": {
                "type": "primary",
                "icon": "el-icon-circle-plus"
            },
            "slot": "rightTop",
            "event": "addItemDialogAction list:1"
        },
        "exportAllAsJSON": {
            "type": "button",
            "label": "导出记录",
            "props": {
                "type": "primary",
                "icon": "el-icon-download"
            },
            "slot": "rightTop",
            "event": "exportAllAsJSON"
        },
        "importAsJSON": {
            "type": "file",
            "label": "",
            "slot": "rightTop",
            "props":{
                "type": "primary",
                "action": "/record/importAsJSON",
                "button-label": "导入记录",
                "button-icon": "el-icon-upload2",
                "show-file-list": false,
                "on-success": function(response, file, fileList){
                    this.$message.success("导入成功"+response.data+"条记录!");
                    ams.callAction("recordList.list:1");
                },
                "on-error": function(err, file, fileList){
                    this.$message.error("导入失败!"+err);
                },
            },
        },
        "updateRecord": {
            "type": "button",
            "label": "编辑",
            "props": {
                "type": "warning",
                "icon": "el-icon-edit"
            },
            "event": "editItemDialogAction list:1"
        },
        "deleteRecord": {
            "type": "button",
            "label": "删除",
            "props": {
                "type": "danger",
                "icon": "el-icon-delete"
            },
            "event": "confirm:确认删除该记录吗? delete list:1"
        },
        "multiDeleteRecord": {
            "slot": "multipleSelect",
            "type": "button",
            "label": "批量删除",
            "props": {
                "type": "danger",
                "icon": "el-icon-delete"
            },
            "event": "confirm:确认批量删除吗? delete list:1"
        },
        "multiExportAsJSON": {
            "slot": "multipleSelect",
            "type": "button",
            "label": "批量导出记录",
            "props": {
                "type": "primary",
                "icon": "el-icon-circle-plus"
            },
            "event": "multiExportAsJSON"
        },
    },
    "actions":{
        addItemDialogAction(){
            return this.callAction("@addItemDialog", recordDialogConfig);
        },
        editItemDialogAction(){
            return this.callAction("@editItemDialog", recordDialogConfig);
        },
        fieldChange({field,name,value,path}){
            if(name=="enable"){
                let index = parseInt(path.substring(path.indexOf("[")+1,path.indexOf("]")));

                let row = this.data.list[index];
                row[name] = value;
                return ams.request({
                    "method": "post",
                    "url": "/record/update",
                    "data": row,
                    "contentType": "json"
                }).then(function(){
                    ams.callAction("recordList.list:1");
                });
            }
        },
        exportAllAsJSON(){
            window.open("/record/exportAsJSON");
        },
        multiExportAsJSON(t){
            let ids = [];
            let array = t.$prevReturn;
            for(let i=0;i<array.length;i++){
                ids.push(array[i].id);
            }
            window.open("/record/exportAsJSON?ids="+ids.join(","));
        },
    }
});